/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.jaas;

import java.io.IOException;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.mule.config.i18n.CoreMessages;
import org.mule.extras.jaas.JaasAuthentication;
import org.mule.extras.jaas.JaasSecurityContextFactory;
import org.mule.extras.jaas.MuleCallbackHandler;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.SecurityException;
import org.mule.umo.security.UMOAuthentication;
import org.mule.umo.security.UMOSecurityContext;
import org.mule.umo.security.UMOSecurityContextFactory;
import org.mule.umo.security.UMOSecurityProvider;
import org.mule.umo.security.UnauthorisedException;
import org.mule.umo.security.UnknownAuthenticationTypeException;
import org.mule.util.FileUtils;

public class JaasSimpleAuthenticationProvider
implements UMOSecurityProvider {
    private String loginConfig;
    private String loginContextName;
    private String credentials;
    private String loginModule;
    private String defaultModule = "org.mule.extras.jaas.loginmodule.DefaultLoginModule";
    private String name;
    private UMOSecurityContextFactory factory;

    public final void setLoginConfig(String loginConfig) {
        this.loginConfig = loginConfig;
    }

    public final String getLoginConfig() {
        return this.loginConfig;
    }

    public final void setLoginContextName(String loginContextName) {
        this.loginContextName = loginContextName;
    }

    public final String getLoginContextName() {
        return this.loginContextName;
    }

    public final String getCredentials() {
        return this.credentials;
    }

    public final void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public final String getLoginModule() {
        return this.loginModule;
    }

    public final void setLoginModule(String loginModule) {
        this.loginModule = loginModule;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    private void configureJaas() throws IOException {
        String loginConfigUrl = "file://" + FileUtils.getResourcePath((String)this.loginConfig, (Class)JaasSimpleAuthenticationProvider.class);
        boolean alreadySet = false;
        int n = 1;
        String prefix = "login.config.url.";
        String existing = null;
        while ((existing = Security.getProperty(prefix + n)) != null && !(alreadySet = existing.equals(loginConfigUrl))) {
            ++n;
        }
        if (!alreadySet) {
            String key = prefix + n;
            Security.setProperty(key, loginConfigUrl);
        }
    }

    public final UMOAuthentication authenticate(UMOAuthentication authentication) throws SecurityException {
        LoginContext loginContext;
        JaasAuthentication auth = (JaasAuthentication)authentication;
        MuleCallbackHandler cbh = new MuleCallbackHandler(auth);
        try {
            loginContext = auth.getSubject() != null ? new LoginContext(this.loginContextName, auth.getSubject(), cbh) : new LoginContext(this.loginContextName, cbh);
        }
        catch (LoginException e) {
            throw new UnauthorisedException(CoreMessages.cannotLoadFromClasspath((String)this.loginContextName));
        }
        try {
            loginContext.login();
        }
        catch (LoginException le) {
            le.fillInStackTrace();
            throw new UnauthorisedException(CoreMessages.authFailedForUser((Object)auth.getPrincipal()));
        }
        Subject subject = loginContext.getSubject();
        JaasAuthentication finalAuth = new JaasAuthentication(auth.getPrincipal(), auth.getCredentials(), subject);
        finalAuth.setAuthenticated(true);
        return finalAuth;
    }

    public final boolean supports(Class aClass) {
        return UMOAuthentication.class.isAssignableFrom(aClass);
    }

    public final UMOSecurityContext createSecurityContext(UMOAuthentication auth) throws UnknownAuthenticationTypeException {
        return this.factory.create(auth);
    }

    public final void initialise() throws InitialisationException {
        if (this.loginConfig == null) {
            try {
                AppConfigurationEntry entry = null;
                JaasConfig.init();
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("credentials", this.credentials);
                entry = this.loginModule != null ? new AppConfigurationEntry(this.loginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options) : new AppConfigurationEntry(this.defaultModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                JaasConfig.addApplicationConfigEntry(this.loginContextName, entry);
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        try {
            this.configureJaas();
        }
        catch (IOException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        try {
            this.factory = new JaasSecurityContextFactory();
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToCreate((String)"JaasProvider"), (Throwable)e, (Initialisable)this);
        }
    }

    public static class JaasConfig
    extends Configuration {
        private static Map appConfigEntries = new HashMap();
        private static JaasConfig jaasConfig;

        public static void init() {
            jaasConfig = new JaasConfig();
            Configuration.setConfiguration(jaasConfig);
        }

        public static JaasConfig getJaasConfig() {
            return jaasConfig;
        }

        public static void addApplicationConfigEntry(String name, AppConfigurationEntry entry) {
            appConfigEntries.put(name, entry);
        }

        public final AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
            if (applicationName == null) {
                throw new IllegalArgumentException("applicationName passed in was null.");
            }
            AppConfigurationEntry entry = (AppConfigurationEntry)appConfigEntries.get(applicationName);
            if (entry == null) {
                return new AppConfigurationEntry[0];
            }
            AppConfigurationEntry[] e = new AppConfigurationEntry[]{entry};
            return e;
        }

        public void refresh() {
        }
    }
}

