/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener;

import org.mule.service.http.api.server.ServerAddress;

public class DefaultServerAddress
implements ServerAddress {
    private final String ip;
    private int port;

    public DefaultServerAddress(String ip, int port) {
        this.port = port;
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getIp() {
        return this.ip;
    }

    public boolean overlaps(ServerAddress serverAddress) {
        return this.port == serverAddress.getPort() && (DefaultServerAddress.isAllInterfaces(this) || DefaultServerAddress.isAllInterfaces(serverAddress));
    }

    public static boolean isAllInterfaces(ServerAddress serverAddress) {
        return "0.0.0.0".equals(serverAddress.getIp());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerAddress that = (ServerAddress)o;
        if (this.port != that.getPort()) {
            return false;
        }
        return this.ip.equals(that.getIp());
    }

    public int hashCode() {
        int result = this.ip.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "ServerAddress{ip='" + this.ip + '\'' + ", port=" + this.port + '}';
    }
}

