/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.extension.http.api.request.authentication.HttpAuthentication;
import org.mule.extension.http.internal.request.HttpRequesterConnectionManager;
import org.mule.extension.http.internal.request.RequestConnectionParams;
import org.mule.extension.http.internal.request.client.DefaultUriParameters;
import org.mule.extension.http.internal.request.client.HttpExtensionClient;
import org.mule.extension.socket.api.socket.tcp.TcpClientSocketProperties;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.util.concurrent.ThreadNameHelper;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.ConfigName;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.module.tls.api.DefaultTlsContextFactoryBuilder;
import org.mule.service.http.api.HttpConstants;
import org.mule.service.http.api.client.HttpClient;
import org.mule.service.http.api.client.HttpClientConfiguration;
import org.mule.service.http.api.client.proxy.ProxyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="request")
public class HttpRequesterProvider
implements CachedConnectionProvider<HttpExtensionClient>,
Initialisable,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequesterProvider.class);
    private static final int UNLIMITED_CONNECTIONS = -1;
    private static final String THREAD_NAME_PREFIX_PATTERN = "%shttp.requester.%s";
    @Inject
    private MuleContext muleContext;
    @ConfigName
    private String configName;
    @ParameterGroup(name="Connection")
    private RequestConnectionParams connectionParams;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="TLS Configuration")
    @Placement(tab="Security")
    private TlsContextFactory tlsContext;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Summary(value="Reusable configuration element for outbound connections through a proxy")
    @Placement(tab="Proxy")
    private ProxyConfig proxyConfig;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(tab="Authentication")
    private HttpAuthentication authentication;
    @Inject
    @DefaultTlsContextFactoryBuilder
    private TlsContextFactoryBuilder defaultTlsContextFactoryBuilder;
    @Inject
    private HttpRequesterConnectionManager connectionManager;

    public ConnectionValidationResult validate(HttpExtensionClient httpClient) {
        return ConnectionValidationResult.success();
    }

    public void initialise() throws InitialisationException {
        HttpConstants.Protocols protocol = this.connectionParams.getProtocol();
        if (this.connectionParams.getPort() == null) {
            this.connectionParams.setPort(protocol.getDefaultPort());
        }
        if (protocol.equals((Object)HttpConstants.Protocols.HTTP) && this.tlsContext != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"TlsContext cannot be configured with protocol HTTP, when using tls:context you must set attribute protocol=\"HTTPS\""), (Initialisable)this);
        }
        if (protocol.equals((Object)HttpConstants.Protocols.HTTPS) && this.tlsContext == null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.defaultTlsContextFactoryBuilder);
            this.tlsContext = this.defaultTlsContextFactoryBuilder.buildDefault();
        }
        if (this.tlsContext != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
        }
        if (this.authentication != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.authentication, (MuleContext)this.muleContext);
        }
        this.verifyConnectionsParameters();
    }

    public void dispose() {
        if (this.authentication != null) {
            LifecycleUtils.disposeIfNeeded((Object)this.authentication, (Logger)logger);
        }
    }

    private void verifyConnectionsParameters() throws InitialisationException {
        if (this.connectionParams.getMaxConnections() < -1 || this.connectionParams.getMaxConnections() == 0) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"The maxConnections parameter only allows positive values or -1 for unlimited concurrent connections."), (Initialisable)this);
        }
        if (!this.connectionParams.getUsePersistentConnections().booleanValue()) {
            this.connectionParams.setConnectionIdleTimeout(0);
        }
    }

    public HttpExtensionClient connect() throws ConnectionException {
        HttpClient httpClient;
        Optional<HttpClient> client = this.connectionManager.lookup(this.configName);
        if (client.isPresent()) {
            httpClient = client.get();
        } else {
            String threadNamePrefix = String.format(THREAD_NAME_PREFIX_PATTERN, ThreadNameHelper.getPrefix((MuleContext)this.muleContext), this.configName);
            HttpClientConfiguration configuration = new HttpClientConfiguration.Builder().setTlsContextFactory(this.tlsContext).setProxyConfig(this.proxyConfig).setClientSocketProperties(this.buildTcpProperties(this.connectionParams.getClientSocketProperties())).setMaxConnections(this.connectionParams.getMaxConnections().intValue()).setUsePersistentConnections(this.connectionParams.getUsePersistentConnections().booleanValue()).setConnectionIdleTimeout(this.connectionParams.getConnectionIdleTimeout().intValue()).setThreadNamePrefix(threadNamePrefix).setOwnerName(this.configName).build();
            httpClient = this.connectionManager.create(this.configName, configuration);
        }
        DefaultUriParameters uriParameters = new DefaultUriParameters(this.connectionParams.getProtocol(), this.connectionParams.getHost(), this.connectionParams.getPort());
        return new HttpExtensionClient(httpClient, uriParameters, this.authentication);
    }

    private org.mule.service.http.api.tcp.TcpClientSocketProperties buildTcpProperties(TcpClientSocketProperties socketProperties) {
        return org.mule.service.http.api.tcp.TcpClientSocketProperties.builder().setSendBufferSize(socketProperties.getSendBufferSize()).setSendBufferSize(socketProperties.getSendBufferSize()).setClientTimeout(socketProperties.getClientTimeout()).setSendTcpNoDelay(Boolean.valueOf(socketProperties.getSendTcpNoDelay())).setLinger(socketProperties.getLinger()).setKeepAlive(socketProperties.getKeepAlive()).setConnectionTimeout(Integer.valueOf(socketProperties.getConnectionTimeout())).build();
    }

    public void disconnect(HttpExtensionClient httpClient) {
    }

    public Integer getPort() {
        return this.connectionParams.getPort();
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }

    public HttpAuthentication getAuthentication() {
        return this.authentication;
    }
}

