/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.util;

import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpToMuleMessage {
    private static Logger logger = LoggerFactory.getLogger(HttpToMuleMessage.class);

    public static MediaType getMediaType(String contentTypeValue, Charset defaultCharset) {
        MediaType mediaType = MediaType.ANY;
        if (contentTypeValue != null) {
            try {
                mediaType = MediaType.parse((String)contentTypeValue);
            }
            catch (IllegalArgumentException e) {
                if (Boolean.parseBoolean(System.getProperty("mule.strictContentType"))) {
                    throw e;
                }
                logger.warn(String.format("%s when parsing Content-Type '%s': %s", e.getClass().getName(), contentTypeValue, e.getMessage()));
                logger.warn(String.format("Using default encoding: %s", Charset.defaultCharset().name()));
            }
        }
        if (!mediaType.getCharset().isPresent()) {
            return mediaType.withCharset(defaultCharset);
        }
        return mediaType;
    }
}

