/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.request.client;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MessageExchangePattern;
import org.mule.runtime.core.api.client.AbstractConnectorMessageProcessorProvider;
import org.mule.runtime.core.api.client.OperationOptions;
import org.mule.runtime.core.api.client.RequestCacheKey;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.module.http.api.client.HttpRequestOptions;
import org.mule.runtime.module.http.internal.request.client.HttpRequesterBuilder;
import org.mule.runtime.module.http.internal.request.client.OneWayHttpRequesterAdapter;
import org.mule.service.http.api.HttpConstants;

public class HttpConnectorMessageProcessorProvider
extends AbstractConnectorMessageProcessorProvider {
    public boolean supportsUrl(String url) {
        return url.startsWith(HttpConstants.Protocols.HTTP.getScheme()) || url.startsWith(HttpConstants.Protocols.HTTPS.getScheme());
    }

    protected Processor buildMessageProcessor(RequestCacheKey cacheKey) throws MuleException {
        OperationOptions operationOptions = cacheKey.getOperationOptions();
        MessageExchangePattern exchangePattern = cacheKey.getExchangePattern();
        String url = cacheKey.getUrl();
        HttpRequesterBuilder httpRequesterBuilder = new HttpRequesterBuilder(this.muleContext).setUrl(url);
        if (operationOptions instanceof HttpRequestOptions) {
            httpRequesterBuilder.setOperationConfig((HttpRequestOptions)operationOptions);
        } else if (operationOptions.getResponseTimeout() != null) {
            httpRequesterBuilder.responseTimeout(operationOptions.getResponseTimeout());
        }
        FlowConstructAware messageProcessor = httpRequesterBuilder.build();
        if (exchangePattern.equals((Object)MessageExchangePattern.ONE_WAY)) {
            messageProcessor = new OneWayHttpRequesterAdapter((Processor)messageProcessor);
        }
        return messageProcessor;
    }
}

