/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.mule.service.http.api.domain.entity.HttpEntity;
import org.mule.service.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.service.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.api.domain.request.HttpRequestContext;
import org.mule.service.http.api.server.RequestHandler;
import org.mule.service.http.api.server.async.HttpResponseReadyCallback;
import org.mule.service.http.api.server.async.ResponseStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorRequestHandler
implements RequestHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int statusCode;
    private String reasonPhrase;
    private String entityFormat;

    public ErrorRequestHandler(int statusCode, String reasonPhrase, String entityFormat) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.entityFormat = entityFormat;
    }

    public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
        String resolvedEntity = String.format(this.entityFormat, requestContext.getRequest().getUri());
        responseCallback.responseReady(((HttpResponseBuilder)HttpResponse.builder().setStatusCode(Integer.valueOf(this.statusCode)).setReasonPhrase(this.reasonPhrase).setEntity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(resolvedEntity.getBytes())))).build(), new ResponseStatusCallback(){

            public void responseSendFailure(Throwable exception) {
                ErrorRequestHandler.this.logger.warn(String.format("Error while sending %s response %s", ErrorRequestHandler.this.statusCode, exception.getMessage()));
                if (ErrorRequestHandler.this.logger.isDebugEnabled()) {
                    ErrorRequestHandler.this.logger.debug("exception thrown", exception);
                }
            }

            public void responseSendSuccessfully() {
            }
        });
    }
}

