/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.execution.MessageProcessContext;
import org.mule.runtime.core.execution.MessageProcessTemplate;
import org.mule.runtime.core.execution.MessageProcessingManager;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.runtime.core.util.SystemUtils;
import org.mule.runtime.module.http.api.listener.HttpListener;
import org.mule.runtime.module.http.api.listener.HttpListenerConfig;
import org.mule.runtime.module.http.api.requester.HttpStreamingType;
import org.mule.runtime.module.http.internal.HttpMessageParsingException;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.listener.DefaultHttpListenerConfig;
import org.mule.runtime.module.http.internal.listener.HttpMessageProcessContext;
import org.mule.runtime.module.http.internal.listener.HttpMessageProcessorTemplate;
import org.mule.runtime.module.http.internal.listener.HttpRequestToMuleEvent;
import org.mule.runtime.module.http.internal.listener.HttpResponseBuilder;
import org.mule.runtime.module.http.internal.listener.ListenerPath;
import org.mule.service.http.api.HttpConstants;
import org.mule.service.http.api.domain.HttpProtocol;
import org.mule.service.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.service.http.api.domain.entity.HttpEntity;
import org.mule.service.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.api.domain.request.HttpRequestContext;
import org.mule.service.http.api.server.RequestHandler;
import org.mule.service.http.api.server.RequestHandlerManager;
import org.mule.service.http.api.server.async.HttpResponseReadyCallback;
import org.mule.service.http.api.server.async.ResponseStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpListener
implements HttpListener,
Initialisable,
MuleContextAware,
FlowConstructAware {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHttpListener.class);
    public static final String SERVER_PROBLEM = "Server encountered a problem";
    private String path;
    private String allowedMethods;
    private Boolean parseRequest;
    private Processor messageProcessor;
    private MuleContext muleContext;
    private FlowConstruct flowConstruct;
    private DefaultHttpListenerConfig config;
    private HttpResponseBuilder responseBuilder;
    private HttpResponseBuilder errorResponseBuilder;
    private HttpStreamingType responseStreamingMode = HttpStreamingType.AUTO;
    private RequestHandlerManager requestHandlerManager;
    private MessageProcessingManager messageProcessingManager;
    private ListenerPath listenerPath;

    public void setListener(Processor messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setAllowedMethods(String allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public void setConfig(DefaultHttpListenerConfig config) {
        this.config = config;
    }

    public void setResponseBuilder(HttpResponseBuilder responseBuilder) {
        this.responseBuilder = responseBuilder;
    }

    public void setErrorResponseBuilder(HttpResponseBuilder errorResponseBuilder) {
        this.errorResponseBuilder = errorResponseBuilder;
    }

    public void setResponseStreamingMode(HttpStreamingType responseStreamingMode) {
        this.responseStreamingMode = responseStreamingMode;
    }

    public void setParseRequest(boolean parseRequest) {
        this.parseRequest = parseRequest;
    }

    @Override
    public HttpListenerConfig getConfig() {
        return this.config;
    }

    @Override
    public synchronized void start() throws MuleException {
        this.requestHandlerManager.start();
    }

    private RequestHandler getRequestHandler() {
        return new RequestHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
                try {
                    HttpMessageProcessorTemplate httpMessageProcessorTemplate = new HttpMessageProcessorTemplate(DefaultHttpListener.this.createEvent(requestContext), DefaultHttpListener.this.messageProcessor, responseCallback, DefaultHttpListener.this.responseBuilder, DefaultHttpListener.this.errorResponseBuilder);
                    HttpMessageProcessContext messageProcessContext = new HttpMessageProcessContext(DefaultHttpListener.this, DefaultHttpListener.this.flowConstruct, DefaultHttpListener.this.config.getWorkManager(), DefaultHttpListener.this.muleContext.getExecutionClassLoader(), DefaultHttpListener.this.muleContext.getErrorTypeLocator());
                    DefaultHttpListener.this.messageProcessingManager.processMessage((MessageProcessTemplate)httpMessageProcessorTemplate, (MessageProcessContext)messageProcessContext);
                }
                catch (IllegalArgumentException | HttpMessageParsingException e) {
                    logger.warn("Exception occurred parsing request:", (Throwable)e);
                    this.sendErrorResponse(HttpConstants.HttpStatus.BAD_REQUEST, ((Throwable)e).getMessage(), responseCallback);
                }
                catch (RuntimeException e) {
                    logger.warn("Exception occurred processing request:", (Throwable)e);
                    this.sendErrorResponse(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, DefaultHttpListener.SERVER_PROBLEM, responseCallback);
                }
                finally {
                    Event.setCurrentEvent(null);
                }
            }

            private void sendErrorResponse(final HttpConstants.HttpStatus status, String message, HttpResponseReadyCallback responseCallback) {
                responseCallback.responseReady(((org.mule.service.http.api.domain.message.response.HttpResponseBuilder)HttpResponse.builder().setStatusCode(Integer.valueOf(status.getStatusCode())).setReasonPhrase(status.getReasonPhrase()).setEntity((HttpEntity)new ByteArrayHttpEntity(message.getBytes()))).build(), new ResponseStatusCallback(){

                    public void responseSendFailure(Throwable exception) {
                        logger.warn("Error while sending {} response {}", (Object)status.getStatusCode(), (Object)exception.getMessage());
                        if (logger.isDebugEnabled()) {
                            logger.debug("Exception thrown", exception);
                        }
                    }

                    public void responseSendSuccessfully() {
                    }
                });
            }
        };
    }

    private Event createEvent(HttpRequestContext requestContext) throws HttpMessageParsingException {
        Event muleEvent = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flowConstruct, (String)DefaultHttpListener.resolveUri(requestContext).toString())).message((Message)HttpRequestToMuleEvent.transform(requestContext, SystemUtils.getDefaultEncoding((MuleContext)this.muleContext), this.parseRequest, this.listenerPath)).flow(this.flowConstruct).session((MuleSession)new DefaultMuleSession()).build();
        Event.setCurrentEvent((Event)muleEvent);
        return muleEvent;
    }

    private static URI resolveUri(HttpRequestContext requestContext) {
        try {
            int port;
            String hostAndPort = DefaultHttpListener.resolveTargetHost(requestContext.getRequest());
            String[] hostAndPortParts = hostAndPort.split(":");
            String host = hostAndPortParts[0];
            int n = port = requestContext.getScheme().equals(HttpConstants.Protocols.HTTP) ? 80 : 4343;
            if (hostAndPortParts.length > 1) {
                port = Integer.valueOf(hostAndPortParts[1]);
            }
            return new URI(requestContext.getScheme(), null, host, port, requestContext.getRequest().getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private static String resolveTargetHost(HttpRequest request) {
        String hostHeaderValue = request.getHeaderValueIgnoreCase("Host");
        if (HttpProtocol.HTTP_1_0.equals((Object)request.getProtocol()) || HttpProtocol.HTTP_0_9.equals((Object)request.getProtocol())) {
            return hostHeaderValue == null ? "0.0.0.0" : hostHeaderValue;
        }
        if (hostHeaderValue == null) {
            throw new IllegalArgumentException("Missing 'host' header");
        }
        return hostHeaderValue;
    }

    public synchronized void initialise() throws InitialisationException {
        if (this.responseBuilder == null) {
            this.responseBuilder = HttpResponseBuilder.emptyInstance(this.muleContext);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.responseBuilder);
        if (this.errorResponseBuilder == null) {
            this.errorResponseBuilder = HttpResponseBuilder.emptyInstance(this.muleContext);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.errorResponseBuilder);
        this.path = HttpParser.sanitizePathWithStartSlash(this.path);
        this.listenerPath = this.config.getFullListenerPath(this.path);
        this.path = this.listenerPath.getResolvedPath();
        this.responseBuilder.setResponseStreaming(this.responseStreamingMode);
        this.validatePath();
        this.parseRequest = this.config.resolveParseRequest(this.parseRequest);
        try {
            this.messageProcessingManager = (MessageProcessingManager)this.muleContext.getRegistry().lookupObject(MessageProcessingManager.class);
            this.requestHandlerManager = this.allowedMethods != null ? this.config.addRequestHandler(Arrays.asList(this.extractAllowedMethods()), this.path, this.getRequestHandler()) : this.config.addRequestHandler(this.path, this.getRequestHandler());
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private void validatePath() throws InitialisationException {
        String[] pathParts = this.path.split("/");
        ArrayList<String> uriParamNames = new ArrayList<String>();
        for (String pathPart : pathParts) {
            if (pathPart.startsWith("{") && pathPart.endsWith("}")) {
                String uriParamName = pathPart.substring(1, pathPart.length() - 1);
                if (uriParamNames.contains(uriParamName)) {
                    throw new InitialisationException(CoreMessages.createStaticMessage((String)String.format("Http Listener with path %s contains duplicated uri param names", this.path)), (Initialisable)this);
                }
                uriParamNames.add(uriParamName);
                continue;
            }
            if (!pathPart.contains("*") || pathPart.length() <= 1) continue;
            throw new InitialisationException(CoreMessages.createStaticMessage((String)String.format("Http Listener with path %s contains an invalid use of a wildcard. Wildcards can only be used at the end of the path (i.e.: /path/*) or between / characters (.i.e.: /path/*/anotherPath))", this.path)), (Initialisable)this);
        }
    }

    private String[] extractAllowedMethods() throws InitialisationException {
        String[] values = this.allowedMethods.split(",");
        String[] normalizedValues = new String[values.length];
        int normalizedValueIndex = 0;
        for (String value : values) {
            normalizedValues[normalizedValueIndex] = value.trim().toUpperCase();
            ++normalizedValueIndex;
        }
        return normalizedValues;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    @Override
    public synchronized void stop() throws MuleException {
        this.requestHandlerManager.stop();
    }

    @Override
    public void dispose() {
        this.requestHandlerManager.dispose();
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

