/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.http.internal.HttpMessageBuilderRef;
import org.mule.runtime.module.http.internal.HttpParam;
import org.mule.runtime.module.http.internal.HttpParamType;
import org.mule.runtime.module.http.internal.HttpSingleParam;
import org.mule.service.http.api.domain.ParameterMap;

public class HttpMessageBuilder
implements Initialisable {
    private String name;
    protected Multimap<HttpParamType, HttpParam> params = ArrayListMultimap.create();

    public void setParams(List<HttpParam> httpParams) {
        for (HttpParam httpParam : httpParams) {
            this.params.put((Object)httpParam.getType(), (Object)httpParam);
        }
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Collection)this.params.values());
    }

    public ParameterMap resolveParams(Event muleEvent, HttpParamType httpParamType, MuleContext muleContext) {
        Collection paramList = this.params.get((Object)httpParamType);
        ParameterMap httpParams = new ParameterMap();
        for (HttpParam httpParam : paramList) {
            httpParam.resolve(httpParams, muleEvent, muleContext);
        }
        return httpParams;
    }

    public void setBuilders(List<HttpMessageBuilderRef> httpBuilderRefs) {
        for (HttpMessageBuilderRef httpBuilderRef : httpBuilderRefs) {
            this.setParams(Lists.newArrayList((Iterable)httpBuilderRef.getRef().params.values()));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addHeader(String headerName, String headerValue) {
        HttpSingleParam httpSingleParam = new HttpSingleParam(HttpParamType.HEADER);
        httpSingleParam.setName(headerName);
        httpSingleParam.setValue(headerValue);
        this.params.put((Object)HttpParamType.HEADER, (Object)httpSingleParam);
    }
}

