/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal;

import java.util.Iterator;
import java.util.Map;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.http.internal.HttpParam;
import org.mule.runtime.module.http.internal.HttpParamType;
import org.mule.service.http.api.domain.ParameterMap;

public class HttpMapParam
extends HttpParam {
    private String expression;

    public HttpMapParam(HttpParamType type) {
        super(type);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public void resolve(ParameterMap parameterMap, Event muleEvent, MuleContext muleContext) {
        Map paramMap = (Map)muleContext.getExpressionManager().evaluate(this.expression, muleEvent).getValue();
        for (Map.Entry entry : paramMap.entrySet()) {
            String paramName = entry.getKey().toString();
            Object paramValue = entry.getValue();
            if (paramValue instanceof Iterable) {
                Iterable iterable = (Iterable)paramValue;
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    parameterMap.put(paramName, this.toStringIfPossible(iterator.next()));
                }
                continue;
            }
            parameterMap.put(paramName, this.toStringIfPossible(paramValue));
        }
    }

    private String toStringIfPossible(Object paramValue) {
        return paramValue != null ? paramValue.toString() : null;
    }
}

