/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request.client;

import org.mule.extension.http.api.request.authentication.HttpAuthentication;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.service.http.api.client.HttpClient;
import org.mule.service.http.api.client.HttpRequestAuthentication;
import org.mule.service.http.api.client.async.ResponseHandler;
import org.mule.service.http.api.domain.message.request.HttpRequest;

public class HttpExtensionClient
implements Startable,
Stoppable {
    private final HttpAuthentication authentication;
    private final HttpClient httpClient;
    private final UriParameters uriParameters;

    public HttpExtensionClient(HttpClient httpClient, UriParameters uriParameters, HttpAuthentication authentication) {
        this.httpClient = httpClient;
        this.uriParameters = uriParameters;
        this.authentication = authentication;
    }

    public UriParameters getDefaultUriParameters() {
        return this.uriParameters;
    }

    public HttpAuthentication getDefaultAuthentication() {
        return this.authentication;
    }

    public void start() throws MuleException {
        this.httpClient.start();
        LifecycleUtils.startIfNeeded((Object)this.authentication);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.authentication);
        this.httpClient.stop();
    }

    public void send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpRequestAuthentication authentication, ResponseHandler handler) {
        this.httpClient.send(request, responseTimeout, followRedirects, authentication, handler);
    }
}

