/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.net.CookieManager;
import javax.inject.Inject;
import org.mule.extension.http.api.HttpSendBodyMode;
import org.mule.extension.http.api.HttpStreamingType;
import org.mule.extension.http.api.request.RamlApiConfiguration;
import org.mule.extension.http.internal.request.HttpRequestOperations;
import org.mule.extension.http.internal.request.HttpRequesterCookieConfig;
import org.mule.extension.http.internal.request.HttpRequesterProvider;
import org.mule.extension.http.internal.request.OtherRequestSettings;
import org.mule.extension.http.internal.request.RequestSettings;
import org.mule.extension.http.internal.request.RequestUrlConfiguration;
import org.mule.extension.http.internal.request.ResponseSettings;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

@Configuration(name="request-config")
@ConnectionProviders(value={HttpRequesterProvider.class})
@Operations(value={HttpRequestOperations.class})
public class HttpRequesterConfig
implements Initialisable,
HttpRequesterCookieConfig {
    @ParameterGroup(name="URL Configuration")
    @NullSafe
    private RequestUrlConfiguration urlConfiguration;
    @ParameterGroup(name="Request Settings")
    @NullSafe
    private RequestSettings requestSettings;
    @ParameterGroup(name="Response Settings")
    @Placement(tab="Response Settings")
    @NullSafe
    private ResponseSettings responseSettings;
    @ParameterGroup(name="Other Settings")
    @NullSafe
    private OtherRequestSettings otherSettings;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="API Specification")
    private RamlApiConfiguration apiConfiguration;
    @Inject
    private MuleContext muleContext;
    private CookieManager cookieManager;

    public void initialise() throws InitialisationException {
        if (this.otherSettings.isEnableCookies()) {
            this.cookieManager = new CookieManager();
        }
    }

    public String getBasePath() {
        return this.urlConfiguration.getBasePath();
    }

    public Boolean getFollowRedirects() {
        return this.requestSettings.getFollowRedirects();
    }

    public Boolean getParseResponse() {
        return this.responseSettings.getParseResponse();
    }

    public HttpStreamingType getRequestStreamingMode() {
        return this.requestSettings.getRequestStreamingMode();
    }

    public HttpSendBodyMode getSendBodyMode() {
        return this.requestSettings.getSendBodyMode();
    }

    public Integer getResponseTimeout() {
        return this.responseSettings.getResponseTimeout();
    }

    @Override
    public boolean isEnableCookies() {
        return this.otherSettings.isEnableCookies();
    }

    public RamlApiConfiguration getApiConfiguration() {
        return this.apiConfiguration;
    }

    @Override
    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }
}

