/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal;

import org.mule.extension.http.api.error.HttpError;
import org.mule.extension.http.api.error.ResourceNotFoundException;
import org.mule.extension.http.api.listener.HttpBasicAuthenticationFilter;
import org.mule.extension.http.internal.BasicSecurityErrorTypeProvider;
import org.mule.extension.http.internal.LoadStaticResourceErrorTypeProvider;
import org.mule.extension.http.internal.StaticResourceLoader;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.security.UnauthorisedException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.security.AuthenticationHandler;

public class HttpOperations {
    @Throws(value={BasicSecurityErrorTypeProvider.class})
    public void basicSecurityFilter(@ParameterGroup(name="Security Filter") HttpBasicAuthenticationFilter filter, AuthenticationHandler authenticationHandler) {
        try {
            filter.authenticate(authenticationHandler);
        }
        catch (UnauthorisedException e) {
            throw new ModuleException((Throwable)e, (ErrorTypeDefinition)HttpError.UNAUTHORIZED);
        }
        catch (SecurityException e) {
            throw new ModuleException((Throwable)e, (ErrorTypeDefinition)HttpError.FORBIDDEN);
        }
        catch (SecurityProviderNotFoundException | UnknownAuthenticationTypeException e) {
            throw new ModuleException(e, (ErrorTypeDefinition)HttpError.SECURITY);
        }
    }

    @Throws(value={LoadStaticResourceErrorTypeProvider.class})
    public Result<?, ?> loadStaticResource(@ParameterGroup(name="Resource") StaticResourceLoader resourceLoader) throws ResourceNotFoundException {
        return resourceLoader.load();
    }
}

