/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.request.client;

import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.module.http.api.client.HttpRequestOptions;
import org.mule.runtime.module.http.api.requester.HttpRequesterConfig;
import org.mule.runtime.module.http.api.requester.HttpStreamingType;

public class DefaultHttpRequestOptions
implements HttpRequestOptions {
    private final String method;
    private final Boolean followsRedirect;
    private final HttpStreamingType requestStreamingMode;
    private final HttpRequesterConfig requestConfig;
    private final boolean disableStatusCodeValidation;
    private final boolean disableParseResponse;
    private final Long responseTimeout;
    private final TlsContextFactory tlsContextFactory;

    public DefaultHttpRequestOptions(String method, Boolean followsRedirect, HttpStreamingType requestStreamingMode, HttpRequesterConfig requestConfig, boolean disableStatusCodeValidation, boolean disableParseResponse, TlsContextFactory tlsContextFactory, Long responseTimeout) {
        this.method = method;
        this.followsRedirect = followsRedirect;
        this.requestStreamingMode = requestStreamingMode;
        this.requestConfig = requestConfig;
        this.disableStatusCodeValidation = disableStatusCodeValidation;
        this.disableParseResponse = disableParseResponse;
        this.tlsContextFactory = tlsContextFactory;
        this.responseTimeout = responseTimeout;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public HttpStreamingType getRequestStreamingMode() {
        return this.requestStreamingMode;
    }

    @Override
    public boolean isParseResponseDisabled() {
        return this.disableParseResponse;
    }

    @Override
    public HttpRequesterConfig getRequesterConfig() {
        return this.requestConfig;
    }

    @Override
    public Boolean isFollowsRedirect() {
        return this.followsRedirect;
    }

    @Override
    public Long getResponseTimeout() {
        return this.responseTimeout;
    }

    @Override
    public boolean isStatusCodeValidationDisabled() {
        return this.disableStatusCodeValidation;
    }

    @Override
    public TlsContextFactory getTlsContextFactory() {
        return this.tlsContextFactory;
    }

    public boolean isOutbound() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpRequestOptions)) {
            return false;
        }
        DefaultHttpRequestOptions that = (DefaultHttpRequestOptions)o;
        if (this.disableStatusCodeValidation != that.isStatusCodeValidationDisabled()) {
            return false;
        }
        if (this.followsRedirect == null ? that.isFollowsRedirect() != null : !this.followsRedirect.equals(that.isFollowsRedirect())) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.getMethod()) : that.getMethod() != null) {
            return false;
        }
        if (this.requestConfig != null ? !this.requestConfig.equals(that.getRequesterConfig()) : that.getRequesterConfig() != null) {
            return false;
        }
        if (this.requestStreamingMode == null ? that.requestStreamingMode != null : this.requestStreamingMode != that.requestStreamingMode) {
            return false;
        }
        if (this.disableParseResponse != that.isParseResponseDisabled()) {
            return false;
        }
        if (this.tlsContextFactory == null ? that.tlsContextFactory != null : !this.tlsContextFactory.equals(that.tlsContextFactory)) {
            return false;
        }
        return this.disableParseResponse == that.isParseResponseDisabled();
    }

    public int hashCode() {
        int hashcodePrimerNumber = 31;
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.followsRedirect != null ? this.followsRedirect.hashCode() : 0);
        result = 31 * result + (this.requestStreamingMode != null ? this.requestStreamingMode.hashCode() : 0);
        result = 31 * result + (this.requestConfig != null ? this.requestConfig.hashCode() : 0);
        result = 31 * result + (this.tlsContextFactory != null ? this.tlsContextFactory.hashCode() : 0);
        result = 31 * result + (this.disableStatusCodeValidation ? 1 : 0);
        result = 31 * result + (this.disableParseResponse ? 1 : 0);
        return result;
    }
}

