/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.request;

import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.util.AttributeEvaluator;
import org.mule.runtime.module.http.api.HttpAuthentication;
import org.mule.runtime.module.http.internal.domain.request.HttpRequestAuthentication;
import org.mule.runtime.module.http.internal.domain.request.HttpRequestBuilder;
import org.mule.runtime.module.http.internal.request.HttpAuthenticationType;

public class DefaultHttpAuthentication
implements HttpAuthentication,
MuleContextAware,
Initialisable {
    private final HttpAuthenticationType type;
    private AttributeEvaluator username = new AttributeEvaluator(null);
    private AttributeEvaluator password = new AttributeEvaluator(null);
    private AttributeEvaluator domain = new AttributeEvaluator(null);
    private AttributeEvaluator workstation = new AttributeEvaluator(null);
    private AttributeEvaluator preemptive = new AttributeEvaluator(String.valueOf(false));
    private MuleContext muleContext;

    public DefaultHttpAuthentication(HttpAuthenticationType type) {
        this.type = type;
    }

    public void initialise() throws InitialisationException {
        this.username.initialize(this.muleContext.getExpressionManager());
        this.password.initialize(this.muleContext.getExpressionManager());
        this.domain.initialize(this.muleContext.getExpressionManager());
        this.workstation.initialize(this.muleContext.getExpressionManager());
        this.preemptive.initialize(this.muleContext.getExpressionManager());
    }

    public String getUsername() {
        return this.username.getRawValue();
    }

    public void setUsername(String username) {
        this.username = new AttributeEvaluator(username);
    }

    public String getPassword() {
        return this.password.getRawValue();
    }

    public void setPassword(String password) {
        this.password = new AttributeEvaluator(password);
    }

    public String getDomain() {
        return this.domain.getRawValue();
    }

    public void setDomain(String domain) {
        this.domain = new AttributeEvaluator(domain);
    }

    public HttpAuthenticationType getType() {
        return this.type;
    }

    public String getWorkstation() {
        return this.workstation.getRawValue();
    }

    public void setWorkstation(String workstation) {
        this.workstation = new AttributeEvaluator(workstation);
    }

    public String getPreemptive() {
        return this.preemptive.getRawValue();
    }

    public void setPreemptive(String preemptive) {
        this.preemptive = new AttributeEvaluator(preemptive);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public HttpRequestAuthentication resolveRequestAuthentication(Event event) {
        HttpRequestAuthentication authentication = new HttpRequestAuthentication(this.type);
        authentication.setUsername(this.username.resolveStringValue(event));
        authentication.setPassword(this.password.resolveStringValue(event));
        authentication.setDomain(this.domain.resolveStringValue(event));
        authentication.setWorkstation(this.workstation.resolveStringValue(event));
        authentication.setPreemptive(this.preemptive.resolveBooleanValue(event));
        return authentication;
    }

    @Override
    public void authenticate(Event muleEvent, HttpRequestBuilder requestBuilder) {
    }

    @Override
    public boolean shouldRetry(Event firstAttemptResponseEvent) {
        return false;
    }
}

