/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.mule.runtime.module.http.internal.listener.ServerAddress;
import org.mule.runtime.module.http.internal.listener.ServerAddressMap;

public class GrizzlyAddressDelegateFilter<F extends BaseFilter>
extends BaseFilter {
    private ServerAddressMap<F> filters = new ServerAddressMap();

    public void onAdded(FilterChain filterChain) {
        super.onAdded(filterChain);
    }

    public void onFilterChainChanged(FilterChain filterChain) {
        super.onFilterChainChanged(filterChain);
    }

    public void onRemoved(FilterChain filterChain) {
        super.onRemoved(filterChain);
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        F filter = this.retrieveFilter(ctx.getConnection());
        if (filter != null) {
            return filter.handleRead(ctx);
        }
        return super.handleRead(ctx);
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        F filter = this.retrieveFilter(ctx.getConnection());
        if (filter != null) {
            return filter.handleWrite(ctx);
        }
        return super.handleWrite(ctx);
    }

    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        F filter = this.retrieveFilter(ctx.getConnection());
        if (filter != null) {
            return filter.handleConnect(ctx);
        }
        return super.handleConnect(ctx);
    }

    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        F filter = this.retrieveFilter(ctx.getConnection());
        if (filter != null) {
            return filter.handleAccept(ctx);
        }
        return super.handleAccept(ctx);
    }

    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        F filter = this.retrieveFilter(ctx.getConnection());
        if (filter != null) {
            return filter.handleEvent(ctx, event);
        }
        return super.handleEvent(ctx, event);
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        F filter = this.retrieveFilter(ctx.getConnection());
        if (filter != null) {
            return filter.handleClose(ctx);
        }
        return super.handleClose(ctx);
    }

    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        F filter = this.retrieveFilter(ctx.getConnection());
        if (filter != null) {
            filter.exceptionOccurred(ctx, error);
        }
        super.exceptionOccurred(ctx, error);
    }

    public FilterChainContext createContext(Connection connection, FilterChainContext.Operation operation) {
        F filter = this.retrieveFilter(connection);
        if (filter != null) {
            return filter.createContext(connection, operation);
        }
        return super.createContext(connection, operation);
    }

    private F retrieveFilter(Connection connection) {
        InetSocketAddress inetAddress = (InetSocketAddress)connection.getLocalAddress();
        int port = inetAddress.getPort();
        String ip = inetAddress.getAddress().getHostAddress();
        return (F)((BaseFilter)this.filters.get(new ServerAddress(ip, port)));
    }

    public synchronized void addFilterForAddress(ServerAddress serverAddress, F filter) {
        this.filters.put(serverAddress, filter);
    }
}

