/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener;

import java.io.ByteArrayInputStream;
import org.mule.runtime.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.runtime.module.http.internal.domain.request.HttpRequestContext;
import org.mule.runtime.module.http.internal.domain.response.HttpResponseBuilder;
import org.mule.runtime.module.http.internal.listener.async.HttpResponseReadyCallback;
import org.mule.runtime.module.http.internal.listener.async.RequestHandler;
import org.mule.runtime.module.http.internal.listener.async.ResponseStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorRequestHandler
implements RequestHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int statusCode;
    private String reasonPhrase;
    private String entityFormat;

    public ErrorRequestHandler(int statusCode, String reasonPhrase, String entityFormat) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.entityFormat = entityFormat;
    }

    @Override
    public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
        String resolvedEntity = String.format(this.entityFormat, requestContext.getRequest().getUri());
        responseCallback.responseReady(new HttpResponseBuilder().setStatusCode(this.statusCode).setReasonPhrase(this.reasonPhrase).setEntity(new InputStreamHttpEntity(new ByteArrayInputStream(resolvedEntity.getBytes()))).build(), new ResponseStatusCallback(){

            @Override
            public void responseSendFailure(Throwable exception) {
                ErrorRequestHandler.this.logger.warn(String.format("Error while sending %s response %s", ErrorRequestHandler.this.statusCode, exception.getMessage()));
                if (ErrorRequestHandler.this.logger.isDebugEnabled()) {
                    ErrorRequestHandler.this.logger.debug("exception thrown", exception);
                }
            }

            @Override
            public void responseSendSuccessfully() {
            }
        });
    }
}

