/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.component;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.activation.MimetypesFileTypeMap;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.internal.component.ResourceNotFoundException;

public class StaticResourceMessageProcessor
implements Processor,
Initialisable {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    public static final String ANY_PATH = "/*";
    public static final String ROOT_PATH = "/";
    private String resourceBase;
    private String defaultFile = "index.html";
    private MimetypesFileTypeMap mimeTypes;

    public void initialise() throws InitialisationException {
        this.mimeTypes = new MimetypesFileTypeMap();
        this.mimeTypes.addMimeTypes("text/javascript js");
        this.mimeTypes.addMimeTypes("text/css css");
    }

    public Event process(Event event) throws MuleException {
        if (StringUtils.isEmpty((String)this.resourceBase)) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"No ResourceBase Defined as part of the static resource message processor."));
        }
        String path = (String)((Object)event.getMessage().getInboundProperty("http.request.path"));
        String contextPath = (String)((Object)event.getMessage().getInboundProperty("http.listener.path"));
        if (contextPath.equals(ANY_PATH)) {
            contextPath = ROOT_PATH;
        }
        if (contextPath.endsWith(ANY_PATH)) {
            contextPath = StringUtils.removeEnd((String)contextPath, (String)ANY_PATH);
        }
        if (!ROOT_PATH.equals(contextPath)) {
            path = path.substring(contextPath.length());
        }
        File file = new File(this.resourceBase + path);
        Event resultEvent = event;
        if (file.isDirectory() && path.endsWith(ROOT_PATH)) {
            file = new File(this.resourceBase + path + this.defaultFile);
        } else if (file.isDirectory()) {
            InternalMessage message = InternalMessage.builder().nullPayload().addOutboundProperty("http.status", (Serializable)((Object)String.valueOf(HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode()))).addOutboundProperty("Content-Length", (Serializable)Integer.valueOf(0)).addOutboundProperty("Location", (Serializable)((Object)(event.getMessage().getInboundProperty("http.request.path") + ROOT_PATH))).build();
            resultEvent = Event.builder((Event)event).message(message).build();
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)baos);
            byte[] buffer = baos.toByteArray();
            String mimetype = this.mimeTypes.getContentType(file);
            if (mimetype == null) {
                mimetype = DEFAULT_MIME_TYPE;
            }
            InternalMessage message = InternalMessage.builder().nullPayload().mediaType(MediaType.parse((String)mimetype)).addOutboundProperty("http.status", (Serializable)((Object)String.valueOf(HttpConstants.HttpStatus.OK.getStatusCode()))).addOutboundProperty("Content-Length", (Serializable)Integer.valueOf(buffer.length)).build();
            resultEvent = Event.builder((Event)event).message(message).build();
        }
        catch (IOException e) {
            try {
                throw new ResourceNotFoundException(I18nMessageFactory.createStaticMessage((String)String.format("The file: %s was not found.", this.resourceBase + path)));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return resultEvent;
    }

    public String getResourceBase() {
        return this.resourceBase;
    }

    public void setResourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
    }

    public String getDefaultFile() {
        return this.defaultFile;
    }

    public void setDefaultFile(String defaultFile) {
        this.defaultFile = defaultFile;
    }
}

