/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.api.requester.proxy;

import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.http.api.requester.proxy.ProxyConfig;
import org.mule.runtime.module.http.internal.request.NtlmProxyConfig;

public class NtlmProxyConfigBuilder {
    public static final int MAXIMUM_PORT_NUMBER = 65535;
    private NtlmProxyConfig ntlmProxyConfig = new NtlmProxyConfig();

    public NtlmProxyConfigBuilder setHost(String host) {
        this.ntlmProxyConfig.setHost(host);
        return this;
    }

    public NtlmProxyConfigBuilder setPort(int port) {
        this.ntlmProxyConfig.setPort(port);
        return this;
    }

    public NtlmProxyConfigBuilder setUsername(String username) {
        this.ntlmProxyConfig.setUsername(username);
        return this;
    }

    public NtlmProxyConfigBuilder setPassword(String password) {
        this.ntlmProxyConfig.setPassword(password);
        return this;
    }

    public ProxyConfig build() {
        Preconditions.checkArgument((this.ntlmProxyConfig.getHost() != null ? 1 : 0) != 0, (String)"Host must be not null");
        Preconditions.checkArgument((this.ntlmProxyConfig.getPort() <= 65535 ? 1 : 0) != 0, (String)"Port was not configured or configured with a value greater than 65535");
        Preconditions.checkArgument((this.ntlmProxyConfig.getNtlmDomain() != null ? 1 : 0) != 0, (String)"Ntlm domain must be not null");
        return this.ntlmProxyConfig;
    }

    public NtlmProxyConfigBuilder setNtlmDomain(String ntlmDomain) {
        this.ntlmProxyConfig.setNtlmDomain(ntlmDomain);
        return this;
    }
}

