/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request.client;

import org.mule.extension.http.api.request.authentication.HttpAuthentication;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.extension.http.api.request.proxy.ProxyConfig;
import org.mule.extension.socket.api.socket.tcp.TcpClientSocketProperties;
import org.mule.runtime.api.tls.TlsContextFactory;

public class HttpClientConfiguration {
    private final UriParameters uriParameters;
    private final HttpAuthentication authentication;
    private final TlsContextFactory tlsContextFactory;
    private final ProxyConfig proxyConfig;
    private final TcpClientSocketProperties clientSocketProperties;
    private final int maxConnections;
    private final boolean usePersistentConnections;
    private final int connectionIdleTimeout;
    private final String threadNamePrefix;
    private final String ownerName;

    private HttpClientConfiguration(UriParameters uriParameters, HttpAuthentication authentication, TlsContextFactory tlsContextFactory, ProxyConfig proxyConfig, TcpClientSocketProperties clientSocketProperties, int maxConnections, boolean usePersistentConnections, int connectionIdleTimeout, String threadNamePrefix, String ownerName) {
        this.uriParameters = uriParameters;
        this.authentication = authentication;
        this.tlsContextFactory = tlsContextFactory;
        this.proxyConfig = proxyConfig;
        this.clientSocketProperties = clientSocketProperties;
        this.maxConnections = maxConnections;
        this.usePersistentConnections = usePersistentConnections;
        this.connectionIdleTimeout = connectionIdleTimeout;
        this.threadNamePrefix = threadNamePrefix;
        this.ownerName = ownerName;
    }

    public UriParameters getUriParameters() {
        return this.uriParameters;
    }

    public HttpAuthentication getAuthentication() {
        return this.authentication;
    }

    public TlsContextFactory getTlsContextFactory() {
        return this.tlsContextFactory;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public TcpClientSocketProperties getClientSocketProperties() {
        return this.clientSocketProperties;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public boolean isUsePersistentConnections() {
        return this.usePersistentConnections;
    }

    public int getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public static class Builder {
        private UriParameters uriParameters;
        private HttpAuthentication authentication;
        private TlsContextFactory tlsContextFactory;
        private ProxyConfig proxyConfig;
        private TcpClientSocketProperties clientSocketProperties;
        private int maxConnections;
        private boolean usePersistentConnections;
        private int connectionIdleTimeout;
        private String threadNamePrefix;
        private String ownerName;

        public Builder setUriParameters(UriParameters uriParameters) {
            this.uriParameters = uriParameters;
            return this;
        }

        public Builder setAuthentication(HttpAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public Builder setTlsContextFactory(TlsContextFactory tlsContextFactory) {
            this.tlsContextFactory = tlsContextFactory;
            return this;
        }

        public Builder setProxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public Builder setClientSocketProperties(TcpClientSocketProperties clientSocketProperties) {
            this.clientSocketProperties = clientSocketProperties;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setUsePersistentConnections(boolean usePersistentConnections) {
            this.usePersistentConnections = usePersistentConnections;
            return this;
        }

        public Builder setConnectionIdleTimeout(int connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            return this;
        }

        public Builder setThreadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public Builder setOwnerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public HttpClientConfiguration build() {
            return new HttpClientConfiguration(this.uriParameters, this.authentication, this.tlsContextFactory, this.proxyConfig, this.clientSocketProperties, this.maxConnections, this.usePersistentConnections, this.connectionIdleTimeout, this.threadNamePrefix, this.ownerName);
        }
    }
}

