/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.InputStream;
import org.mule.extension.http.api.HttpSendBodyMode;
import org.mule.extension.http.api.HttpStreamingType;
import org.mule.extension.http.api.request.authentication.HttpAuthentication;
import org.mule.extension.http.api.request.authentication.UsernamePasswordAuthentication;
import org.mule.extension.http.api.request.builder.HttpRequesterRequestBuilder;
import org.mule.extension.http.api.request.client.HttpClient;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.extension.http.api.request.validator.ResponseValidator;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.extension.http.internal.request.HttpResponseToMuleMessage;
import org.mule.extension.http.internal.request.MuleEventToHttpRequest;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.TransformationService;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.context.notification.ConnectorMessageNotification;
import org.mule.runtime.core.context.notification.NotificationHelper;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.internal.domain.request.HttpRequest;
import org.mule.runtime.module.http.internal.domain.request.HttpRequestAuthentication;
import org.mule.runtime.module.http.internal.domain.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequester {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequester.class);
    private static final String REMOTELY_CLOSED = "Remotely closed";
    private final boolean followRedirects;
    private final HttpAuthentication authentication;
    private final boolean parseResponse;
    private final int responseTimeout;
    private final ResponseValidator responseValidator;
    private final HttpRequesterConfig config;
    private final NotificationHelper notificationHelper;
    private final MuleEventToHttpRequest eventToHttpRequest;

    public HttpRequester(MuleEventToHttpRequest eventToHttpRequest, boolean followRedirects, HttpAuthentication authentication, boolean parseResponse, int responseTimeout, ResponseValidator responseValidator, HttpRequesterConfig config) {
        this.followRedirects = followRedirects;
        this.authentication = authentication;
        this.parseResponse = parseResponse;
        this.responseTimeout = responseTimeout;
        this.responseValidator = responseValidator;
        this.config = config;
        this.eventToHttpRequest = eventToHttpRequest;
        this.notificationHelper = new NotificationHelper((ServerNotificationHandler)config.getMuleContext().getNotificationManager(), ConnectorMessageNotification.class, false);
    }

    public Message doRequest(Event muleEvent, HttpClient client, HttpRequesterRequestBuilder requestBuilder, boolean checkRetry, MuleContext muleContext, FlowConstruct flowConstruct) throws MuleException {
        HttpResponse response;
        HttpRequest httpRequest = this.eventToHttpRequest.create(muleEvent, requestBuilder, this.authentication, muleContext);
        try {
            this.notificationHelper.fireNotification((Object)this, muleEvent, httpRequest.getUri(), flowConstruct, 804);
            response = client.send(httpRequest, this.responseTimeout, this.followRedirects, this.resolveAuthentication(this.authentication));
        }
        catch (Exception e) {
            this.checkIfRemotelyClosed(e, client.getDefaultUriParameters());
            throw new MessagingException(CoreMessages.createStaticMessage((String)this.getErrorMessage(httpRequest)), muleEvent, (Throwable)e);
        }
        HttpResponseToMuleMessage httpResponseToMuleMessage = new HttpResponseToMuleMessage(this.config, this.parseResponse, muleContext);
        Message responseMessage = httpResponseToMuleMessage.convert(muleEvent, response, httpRequest.getUri());
        Event responseEvent = Event.builder((Event)muleEvent).message(InternalMessage.builder((Message)responseMessage).build()).synchronous(muleEvent.isSynchronous()).build();
        if (this.resendRequest(responseEvent, checkRetry, this.authentication)) {
            this.consumePayload(responseEvent, muleContext);
            responseMessage = this.doRequest(responseEvent, client, requestBuilder, false, muleContext, flowConstruct);
        }
        this.notificationHelper.fireNotification((Object)this, muleEvent, httpRequest.getUri(), flowConstruct, 853);
        this.responseValidator.validate(responseMessage, muleContext);
        return responseMessage;
    }

    private String getErrorMessage(HttpRequest httpRequest) {
        return String.format("Error sending HTTP request to %s", httpRequest.getUri());
    }

    private boolean resendRequest(Event muleEvent, boolean retry, HttpAuthentication authentication) throws MuleException {
        return retry && authentication != null && authentication.shouldRetry(muleEvent);
    }

    private void consumePayload(Event event, MuleContext muleContext) {
        if (event.getMessage().getPayload().getValue() instanceof InputStream) {
            try {
                event.getMessageAsBytes(muleContext);
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private HttpRequestAuthentication resolveAuthentication(HttpAuthentication authentication) {
        HttpRequestAuthentication requestAuthentication = null;
        if (authentication instanceof UsernamePasswordAuthentication) {
            requestAuthentication = ((UsernamePasswordAuthentication)authentication).buildRequestAuthentication();
        }
        return requestAuthentication;
    }

    private void checkIfRemotelyClosed(Exception exception, UriParameters uriParameters) {
        if (HttpConstants.Protocols.HTTPS.getScheme().equals((Object)uriParameters.getScheme()) && StringUtils.containsIgnoreCase((String)exception.getMessage(), (String)REMOTELY_CLOSED)) {
            logger.error("Remote host closed connection. Possible SSL/TLS handshake issue. Check protocols, cipher suites and certificate set up. Use -Djavax.net.debug=handshake for further debugging.");
        }
    }

    public static class Builder {
        private String uri;
        private String method;
        private boolean followRedirects;
        private HttpStreamingType requestStreamingMode;
        private HttpSendBodyMode sendBodyMode;
        private HttpAuthentication authentication;
        private int responseTimeout;
        private boolean parseResponse;
        private ResponseValidator responseValidator;
        private HttpRequesterConfig config;
        private TransformationService transformationService;

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder setRequestStreamingMode(HttpStreamingType requestStreamingMode) {
            this.requestStreamingMode = requestStreamingMode;
            return this;
        }

        public Builder setSendBodyMode(HttpSendBodyMode sendBodyMode) {
            this.sendBodyMode = sendBodyMode;
            return this;
        }

        public Builder setAuthentication(HttpAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public Builder setParseResponse(boolean parseResponse) {
            this.parseResponse = parseResponse;
            return this;
        }

        public Builder setResponseTimeout(int responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public Builder setResponseValidator(ResponseValidator responseValidator) {
            this.responseValidator = responseValidator;
            return this;
        }

        public Builder setConfig(HttpRequesterConfig config) {
            this.config = config;
            return this;
        }

        public Builder setTransformationService(TransformationService transformationService) {
            this.transformationService = transformationService;
            return this;
        }

        public HttpRequester build() {
            MuleEventToHttpRequest eventToHttpRequest = new MuleEventToHttpRequest(this.config, this.uri, this.method, this.requestStreamingMode, this.sendBodyMode, this.transformationService);
            return new HttpRequester(eventToHttpRequest, this.followRedirects, this.authentication, this.parseResponse, this.responseTimeout, this.responseValidator, this.config);
        }
    }
}

