/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener.server;

import org.mule.extension.http.internal.listener.HttpListener;
import org.mule.extension.http.internal.listener.HttpListenerProvider;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.listener.ListenerPath;

@Configuration(name="listener-config")
@ConnectionProviders(value={HttpListenerProvider.class})
@Sources(value={HttpListener.class})
public class HttpListenerConfig
implements Initialisable {
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String basePath;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced")
    private Boolean parseRequest;

    public void initialise() throws InitialisationException {
        this.basePath = HttpParser.sanitizePathWithStartSlash(this.basePath);
    }

    public ListenerPath getFullListenerPath(String listenerPath) {
        Preconditions.checkArgument((boolean)listenerPath.startsWith("/"), (String)"listenerPath must start with /");
        return new ListenerPath(this.basePath, listenerPath);
    }

    public Boolean resolveParseRequest(Boolean listenerParseRequest) {
        return listenerParseRequest != null ? listenerParseRequest : (this.parseRequest != null ? this.parseRequest : true);
    }
}

