/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.internal.listener.HttpRequestAttributesBuilder;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.SystemUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.http.api.HttpHeaders;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.domain.EmptyHttpEntity;
import org.mule.runtime.module.http.internal.domain.HttpEntity;
import org.mule.runtime.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.runtime.module.http.internal.domain.MultipartHttpEntity;
import org.mule.runtime.module.http.internal.domain.request.HttpRequest;
import org.mule.runtime.module.http.internal.domain.request.HttpRequestContext;
import org.mule.runtime.module.http.internal.listener.HttpRequestParsingException;
import org.mule.runtime.module.http.internal.listener.ListenerPath;
import org.mule.runtime.module.http.internal.multipart.HttpPartDataSource;
import org.mule.runtime.module.http.internal.util.HttpToMuleMessage;

public class HttpRequestToResult {
    public static Result<Object, HttpRequestAttributes> transform(HttpRequestContext requestContext, MuleContext muleContext, Boolean parseRequest, ListenerPath listenerPath) throws HttpRequestParsingException {
        HttpRequest request = requestContext.getRequest();
        MediaType mediaType = HttpToMuleMessage.getMediaType(request.getHeaderValueIgnoreCase("Content-Type"), SystemUtils.getDefaultEncoding((MuleContext)muleContext));
        InputStream payload = null;
        if (parseRequest.booleanValue()) {
            HttpEntity entity = request.getEntity();
            if (entity != null && !(entity instanceof EmptyHttpEntity)) {
                if (entity instanceof MultipartHttpEntity) {
                    try {
                        payload = HttpPartDataSource.multiPartPayloadForAttachments((MultipartHttpEntity)entity);
                    }
                    catch (IOException e) {
                        throw new HttpRequestParsingException(e.getMessage(), e);
                    }
                } else if (mediaType != null) {
                    if (mediaType.matches(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED)) {
                        try {
                            payload = HttpParser.decodeUrlEncodedBody(IOUtils.toString((InputStream)((InputStreamHttpEntity)entity).getInputStream()), (Charset)mediaType.getCharset().get());
                        }
                        catch (IllegalArgumentException e) {
                            throw new HttpRequestParsingException("Cannot decode x-www-form-urlencoded payload", e);
                        }
                    } else if (entity instanceof InputStreamHttpEntity) {
                        payload = ((InputStreamHttpEntity)entity).getInputStream();
                    }
                } else if (entity instanceof InputStreamHttpEntity) {
                    payload = ((InputStreamHttpEntity)entity).getInputStream();
                }
            }
        } else {
            InputStreamHttpEntity inputStreamEntity = request.getInputStreamEntity();
            if (inputStreamEntity != null) {
                payload = inputStreamEntity.getInputStream();
            }
        }
        HttpRequestAttributes attributes = new HttpRequestAttributesBuilder().setRequestContext(requestContext).setListenerPath(listenerPath).build();
        return Result.builder().output((Object)payload).mediaType(mediaType).attributes((Attributes)attributes).build();
    }
}

