/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal;

import javax.inject.Inject;
import org.mule.extension.http.api.listener.HttpBasicAuthenticationFilter;
import org.mule.extension.http.internal.StaticResourceLoader;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.http.internal.component.ResourceNotFoundException;

public class HttpOperations {
    @Inject
    private MuleContext muleContext;

    public void basicSecurityFilter(String realm, @Optional String securityProviders, Event event) throws MuleException {
        HttpBasicAuthenticationFilter filter = this.createFilter(realm, securityProviders);
        filter.doFilter(event);
    }

    public Result<?, ?> loadStaticResource(@ParameterGroup(value="Resource") StaticResourceLoader resourceLoader, Event event) throws ResourceNotFoundException, InitialisationException {
        return Result.builder((Message)resourceLoader.load(event)).build();
    }

    private HttpBasicAuthenticationFilter createFilter(String realm, String securityProviders) throws InitialisationException {
        HttpBasicAuthenticationFilter filter = new HttpBasicAuthenticationFilter();
        filter.setRealm(realm);
        filter.setSecurityProviders(securityProviders);
        filter.setMuleContext(this.muleContext);
        filter.initialise();
        return filter;
    }
}

