/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.DefaultMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.CompletionHandler;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.debug.DebugInfoProvider;
import org.mule.api.debug.ErrorFieldDebugInfo;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.api.debug.FieldDebugInfoFactory;
import org.mule.api.debug.SimpleFieldDebugInfo;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.construct.Flow;
import org.mule.context.notification.ConnectorMessageNotification;
import org.mule.context.notification.NotificationHelper;
import org.mule.module.http.api.HttpAuthentication;
import org.mule.module.http.api.requester.HttpSendBodyMode;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.ParameterMap;
import org.mule.module.http.internal.domain.request.HttpRequest;
import org.mule.module.http.internal.domain.request.HttpRequestAuthentication;
import org.mule.module.http.internal.domain.request.HttpRequestBuilder;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.request.DefaultHttpAuthentication;
import org.mule.module.http.internal.request.DefaultHttpRequesterConfig;
import org.mule.module.http.internal.request.HttpClient;
import org.mule.module.http.internal.request.HttpRequesterRequestBuilder;
import org.mule.module.http.internal.request.HttpResponseToMuleEvent;
import org.mule.module.http.internal.request.MuleEventToHttpRequest;
import org.mule.module.http.internal.request.ResponseValidator;
import org.mule.module.http.internal.request.ResponseValidatorException;
import org.mule.module.http.internal.request.SuccessStatusCodeValidator;
import org.mule.processor.AbstractNonBlockingMessageProcessor;
import org.mule.util.AttributeEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpRequester
extends AbstractNonBlockingMessageProcessor
implements Initialisable,
MuleContextAware,
FlowConstructAware,
DebugInfoProvider {
    public static final List<String> DEFAULT_EMPTY_BODY_METHODS = Lists.newArrayList((Object[])new String[]{"GET", "HEAD", "OPTIONS"});
    public static final String DEFAULT_PAYLOAD_EXPRESSION = "#[payload]";
    public static final String DEFAULT_FOLLOW_REDIRECTS = "true";
    private static final Logger logger = LoggerFactory.getLogger(DefaultHttpRequester.class);
    static final String URI_DEBUG = "URI";
    static final String METHOD_DEBUG = "Method";
    static final String STREAMING_MODE_DEBUG = "Streaming Mode";
    static final String SEND_BODY_DEBUG = "Send Body";
    static final String FOLLOW_REDIRECTS_DEBUG = "Follow Redirects";
    static final String PARSE_RESPONSE_DEBUG = "Parse Response";
    static final String RESPONSE_TIMEOUT_DEBUG = "Response Timeout";
    static final String USERNAME_DEBUG = "Username";
    static final String NO_SECURITY_CONFIGURED = "No security configured";
    static final String SECURITY_DEBUG = "Security";
    static final String DOMAIN_DEBUG = "Domain";
    static final String PASSWORD_DEBUG = "Password";
    static final String WORKSTATION_DEBUG = "Workstation";
    static final String AUTHENTICATION_TYPE_DEBUG = "Authentication Type";
    static final String QUERY_PARAMS_DEBUG = "Query Params";
    static final String REMOTELY_CLOSED = "Remotely closed";
    private DefaultHttpRequesterConfig requestConfig;
    private HttpRequesterRequestBuilder requestBuilder;
    private ResponseValidator responseValidator = new SuccessStatusCodeValidator("0..399");
    private AttributeEvaluator host = new AttributeEvaluator(null);
    private AttributeEvaluator port = new AttributeEvaluator(null);
    private AttributeEvaluator basePath = new AttributeEvaluator(null);
    private AttributeEvaluator path = new AttributeEvaluator(null);
    private AttributeEvaluator url = new AttributeEvaluator(null);
    private AttributeEvaluator method = new AttributeEvaluator("GET");
    private AttributeEvaluator followRedirects = new AttributeEvaluator(null);
    private AttributeEvaluator requestStreamingMode = new AttributeEvaluator(null);
    private AttributeEvaluator sendBodyMode = new AttributeEvaluator(null);
    private AttributeEvaluator parseResponse = new AttributeEvaluator(null);
    private AttributeEvaluator responseTimeout = new AttributeEvaluator(null);
    private String source;
    private String target;
    private MuleContext muleContext;
    private FlowConstruct flowConstruct;
    private MuleEventToHttpRequest muleEventToHttpRequest;
    private HttpResponseToMuleEvent httpResponseToMuleEvent;
    private NotificationHelper notificationHelper;

    public void initialise() throws InitialisationException {
        if (this.requestConfig == null) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"The config-ref attribute is required in the HTTP request element"), (Initialisable)this);
        }
        if (this.requestBuilder == null) {
            this.requestBuilder = new HttpRequesterRequestBuilder();
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.requestBuilder);
        this.setEmptyAttributesFromConfig();
        this.validateRequiredProperties();
        this.basePath = new AttributeEvaluator(this.requestConfig.getBasePath());
        this.muleEventToHttpRequest = new MuleEventToHttpRequest(this, this.muleContext, this.requestStreamingMode, this.sendBodyMode);
        this.httpResponseToMuleEvent = new HttpResponseToMuleEvent(this, this.muleContext, this.parseResponse);
        this.initializeAttributeEvaluators(this.host, this.port, this.method, this.path, this.basePath, this.url, this.followRedirects, this.requestStreamingMode, this.sendBodyMode, this.parseResponse, this.responseTimeout);
        this.notificationHelper = new NotificationHelper((ServerNotificationHandler)this.muleContext.getNotificationManager(), ConnectorMessageNotification.class, false);
    }

    private void setEmptyAttributesFromConfig() throws InitialisationException {
        if (this.host.getRawValue() == null) {
            this.setHost(this.requestConfig.getHost());
        }
        if (this.port.getRawValue() == null) {
            this.setPort(this.requestConfig.getPort());
        }
        if (this.followRedirects.getRawValue() == null) {
            String requestFollowRedirect = this.requestConfig.getFollowRedirects();
            if (requestFollowRedirect == null) {
                requestFollowRedirect = DEFAULT_FOLLOW_REDIRECTS;
            }
            this.setFollowRedirects(requestFollowRedirect);
        }
        if (this.requestStreamingMode.getRawValue() == null) {
            this.setRequestStreamingMode(this.requestConfig.getRequestStreamingMode());
        }
        if (this.sendBodyMode.getRawValue() == null) {
            this.setSendBodyMode(this.requestConfig.getSendBodyMode());
        }
        if (this.parseResponse.getRawValue() == null) {
            this.setParseResponse(this.requestConfig.getParseResponse());
        }
        if (this.responseTimeout.getRawValue() == null && this.requestConfig.getResponseTimeout() != null) {
            this.setResponseTimeout(this.requestConfig.getResponseTimeout());
        }
    }

    private void validateRequiredProperties() throws InitialisationException {
        if (this.url.getRawValue() == null) {
            if (this.host.getRawValue() == null) {
                throw new InitialisationException(CoreMessages.createStaticMessage((String)"No host defined. Set the host attribute either in the request or request-config elements"), (Initialisable)this);
            }
            if (this.port.getRawValue() == null) {
                throw new InitialisationException(CoreMessages.createStaticMessage((String)"No port defined. Set the host attribute either in the request or request-config elements"), (Initialisable)this);
            }
            if (this.path.getRawValue() == null) {
                throw new InitialisationException(CoreMessages.createStaticMessage((String)"The path attribute is required in the HTTP request element"), (Initialisable)this);
            }
        }
    }

    private void initializeAttributeEvaluators(AttributeEvaluator ... attributeEvaluators) {
        for (AttributeEvaluator attributeEvaluator : attributeEvaluators) {
            if (attributeEvaluator == null) continue;
            attributeEvaluator.initialize(this.muleContext.getExpressionManager());
        }
    }

    protected MuleEvent processBlocking(MuleEvent muleEvent) throws MuleException {
        return this.innerProcess(muleEvent, true);
    }

    protected void processNonBlocking(MuleEvent muleEvent, CompletionHandler completionHandler) throws MuleException {
        this.innerProcessNonBlocking(muleEvent, completionHandler, true);
    }

    protected void innerProcessNonBlocking(final MuleEvent muleEvent, final CompletionHandler completionHandler, final boolean checkRetry) throws MuleException {
        final HttpAuthentication authentication = this.requestConfig.getAuthentication();
        final HttpRequest httpRequest = this.createHttpRequest(muleEvent, authentication);
        this.notificationHelper.fireNotification(muleEvent, httpRequest.getUri(), muleEvent.getFlowConstruct(), 804);
        this.getHttpClient().send(httpRequest, this.resolveResponseTimeout(muleEvent), this.followRedirects.resolveBooleanValue(muleEvent), this.resolveAuthentication(muleEvent), new CompletionHandler<HttpResponse, Exception>(){

            public void onFailure(Exception exception) {
                MessagingException msgException = new MessagingException(CoreMessages.createStaticMessage((String)"Error sending HTTP request"), this.resetMuleEventForNewThread(muleEvent), (Throwable)exception, (MessageProcessor)DefaultHttpRequester.this);
                DefaultHttpRequester.this.checkIfRemotelyClosed(exception);
                completionHandler.onFailure((Throwable)msgException);
            }

            public void onCompletion(HttpResponse httpResponse) {
                try {
                    DefaultHttpRequester.this.httpResponseToMuleEvent.convert(muleEvent, httpResponse, httpRequest.getUri());
                    DefaultHttpRequester.this.notificationHelper.fireNotification(muleEvent, httpRequest.getUri(), muleEvent.getFlowConstruct(), 853);
                    this.resetMuleEventForNewThread(muleEvent);
                    if (DefaultHttpRequester.this.resendRequest(muleEvent, checkRetry, authentication)) {
                        DefaultHttpRequester.this.consumePayload(muleEvent);
                        DefaultHttpRequester.this.innerProcessNonBlocking(muleEvent, completionHandler, false);
                    } else {
                        DefaultHttpRequester.this.validateResponse(muleEvent);
                        completionHandler.onCompletion((Object)muleEvent);
                    }
                }
                catch (MessagingException messagingException) {
                    completionHandler.onFailure((Throwable)messagingException);
                }
                catch (MuleException muleException) {
                    completionHandler.onFailure((Throwable)new MessagingException(this.resetMuleEventForNewThread(muleEvent), (Throwable)muleException, (MessageProcessor)DefaultHttpRequester.this));
                }
                finally {
                    RequestContext.clear();
                }
            }

            private MuleEvent resetMuleEventForNewThread(MuleEvent event) {
                ((DefaultMuleEvent)event).resetAccessControl();
                OptimizedRequestContext.unsafeSetEvent((MuleEvent)event);
                return event;
            }
        }, this.getWorkManager(muleEvent));
    }

    private void checkIfRemotelyClosed(Exception exception) {
        if (this.requestConfig.getTlsContext() != null && StringUtils.containsIgnoreCase((String)exception.getMessage(), (String)REMOTELY_CLOSED)) {
            logger.error("Remote host closed connection. Possible SSL/TLS handshake issue. Check protocols, cipher suites and certificate set up. Use -Djavax.net.debug=handshake for further debugging.");
        }
    }

    private WorkManager getWorkManager(MuleEvent event) {
        FlowConstruct currentFlowConstruct;
        FlowConstruct flowConstruct = currentFlowConstruct = this.flowConstruct != null ? this.flowConstruct : event.getFlowConstruct();
        if (currentFlowConstruct != null && currentFlowConstruct instanceof Flow) {
            return ((Flow)currentFlowConstruct).getWorkManager();
        }
        return null;
    }

    private MuleEvent innerProcess(MuleEvent muleEvent, boolean checkRetry) throws MuleException {
        HttpResponse response;
        HttpAuthentication authentication = this.requestConfig.getAuthentication();
        HttpRequest httpRequest = this.createHttpRequest(muleEvent, authentication);
        try {
            this.notificationHelper.fireNotification(muleEvent, httpRequest.getUri(), muleEvent.getFlowConstruct(), 804);
            response = this.getHttpClient().send(httpRequest, this.resolveResponseTimeout(muleEvent), this.followRedirects.resolveBooleanValue(muleEvent), this.resolveAuthentication(muleEvent));
        }
        catch (Exception e) {
            this.checkIfRemotelyClosed(e);
            throw new MessagingException(CoreMessages.createStaticMessage((String)"Error sending HTTP request"), muleEvent, (Throwable)e, (MessageProcessor)this);
        }
        this.httpResponseToMuleEvent.convert(muleEvent, response, httpRequest.getUri());
        this.notificationHelper.fireNotification(muleEvent, httpRequest.getUri(), muleEvent.getFlowConstruct(), 853);
        if (this.resendRequest(muleEvent, checkRetry, authentication)) {
            this.consumePayload(muleEvent);
            muleEvent = this.innerProcess(muleEvent, false);
        } else {
            this.validateResponse(muleEvent);
        }
        return muleEvent;
    }

    private HttpClient getHttpClient() {
        return this.requestConfig.getHttpClient();
    }

    private void validateResponse(MuleEvent muleEvent) throws ResponseValidatorException {
        this.responseValidator.validate(muleEvent);
    }

    private boolean resendRequest(MuleEvent muleEvent, boolean retry, HttpAuthentication authentication) throws MuleException {
        return retry && authentication != null && authentication.shouldRetry(muleEvent);
    }

    private HttpRequest createHttpRequest(MuleEvent muleEvent, HttpAuthentication authentication) throws MuleException {
        HttpRequestBuilder builder = this.muleEventToHttpRequest.create(muleEvent, this.method.resolveStringValue(muleEvent), this.resolveURI(muleEvent));
        if (authentication != null) {
            authentication.authenticate(muleEvent, builder);
        }
        return builder.build();
    }

    private HttpRequestAuthentication resolveAuthentication(MuleEvent event) {
        HttpRequestAuthentication requestAuthentication = null;
        if (this.requestConfig.getAuthentication() instanceof DefaultHttpAuthentication) {
            requestAuthentication = ((DefaultHttpAuthentication)this.requestConfig.getAuthentication()).resolveRequestAuthentication(event);
        }
        return requestAuthentication;
    }

    private int resolveResponseTimeout(MuleEvent muleEvent) {
        if (this.responseTimeout.getRawValue() == null) {
            return muleEvent.getTimeout();
        }
        return this.responseTimeout.resolveIntegerValue(muleEvent);
    }

    private String resolveURI(MuleEvent muleEvent) throws MessagingException {
        if (this.url.getRawValue() != null) {
            return this.url.resolveStringValue(muleEvent);
        }
        String resolvedPath = this.replaceUriParams(this.buildPath(this.basePath.resolveStringValue(muleEvent), this.path.resolveStringValue(muleEvent)), muleEvent);
        resolvedPath = HttpParser.encodeSpaces(resolvedPath);
        return String.format("%s://%s:%s%s", this.requestConfig.getScheme(), this.host.resolveStringValue(muleEvent), this.port.resolveIntegerValue(muleEvent), resolvedPath);
    }

    private String replaceUriParams(String path, MuleEvent event) {
        if (this.requestBuilder == null) {
            return path;
        }
        return this.requestBuilder.replaceUriParams(path, event);
    }

    protected String buildPath(String basePath, String path) {
        String resolvedBasePath = basePath;
        String resolvedRequestPath = path;
        if (!resolvedBasePath.startsWith("/")) {
            resolvedBasePath = "/" + resolvedBasePath;
        }
        if (resolvedBasePath.endsWith("/") && resolvedRequestPath.startsWith("/")) {
            resolvedBasePath = resolvedBasePath.substring(0, resolvedBasePath.length() - 1);
        }
        if (!(resolvedBasePath.endsWith("/") || resolvedRequestPath.startsWith("/") || resolvedRequestPath.isEmpty())) {
            resolvedBasePath = resolvedBasePath + "/";
        }
        return resolvedBasePath + resolvedRequestPath;
    }

    private void consumePayload(MuleEvent event) {
        if (event.getMessage().getPayload() instanceof InputStream) {
            try {
                event.getMessage().getPayloadAsBytes();
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    public String getHost() {
        return this.host.getRawValue();
    }

    public void setHost(String host) {
        this.host = new AttributeEvaluator(host);
    }

    public String getPort() {
        return this.port.getRawValue();
    }

    public void setPort(String port) {
        this.port = new AttributeEvaluator(port);
    }

    public String getPath() {
        return this.path.getRawValue();
    }

    public void setPath(String path) {
        this.path = new AttributeEvaluator(path);
    }

    public String getUrl() {
        return this.url.getRawValue();
    }

    public void setUrl(String url) {
        this.url = new AttributeEvaluator(url);
    }

    public HttpRequesterRequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    public void setRequestBuilder(HttpRequesterRequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    public String getMethod() {
        return this.method.getRawValue();
    }

    public void setMethod(String method) {
        this.method = new AttributeEvaluator(method);
    }

    public DefaultHttpRequesterConfig getConfig() {
        return this.requestConfig;
    }

    public void setConfig(DefaultHttpRequesterConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    public void setFollowRedirects(String followsRedirects) {
        this.followRedirects = new AttributeEvaluator(followsRedirects);
    }

    public void setRequestStreamingMode(String requestStreamingMode) {
        this.requestStreamingMode = new AttributeEvaluator(requestStreamingMode);
    }

    public ResponseValidator getResponseValidator() {
        return this.responseValidator;
    }

    public void setResponseValidator(ResponseValidator responseValidator) {
        this.responseValidator = responseValidator;
    }

    public void setSendBodyMode(String sendBodyMode) {
        this.sendBodyMode = new AttributeEvaluator(sendBodyMode);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setParseResponse(String parseResponse) {
        this.parseResponse = new AttributeEvaluator(parseResponse);
    }

    public void setResponseTimeout(String responseTimeout) {
        this.responseTimeout = new AttributeEvaluator(responseTimeout);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public List<FieldDebugInfo<?>> getDebugInfo(final MuleEvent event) {
        ArrayList fields = new ArrayList();
        fields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)URI_DEBUG, String.class, (FieldDebugInfoFactory.FieldEvaluator)new FieldDebugInfoFactory.FieldEvaluator(){

            public Object evaluate() throws Exception {
                return DefaultHttpRequester.this.resolveURI(event);
            }
        }));
        fields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)METHOD_DEBUG, String.class, (AttributeEvaluator)this.method, (MuleEvent)event));
        fields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)STREAMING_MODE_DEBUG, Boolean.class, (AttributeEvaluator)this.requestStreamingMode, (MuleEvent)event));
        fields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)SEND_BODY_DEBUG, HttpSendBodyMode.class, (FieldDebugInfoFactory.FieldEvaluator)new FieldDebugInfoFactory.FieldEvaluator(){

            public Object evaluate() throws Exception {
                return HttpSendBodyMode.valueOf(DefaultHttpRequester.this.sendBodyMode.resolveStringValue(event));
            }
        }));
        fields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)FOLLOW_REDIRECTS_DEBUG, Boolean.class, (AttributeEvaluator)this.followRedirects, (MuleEvent)event));
        fields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)PARSE_RESPONSE_DEBUG, Boolean.class, (AttributeEvaluator)this.parseResponse, (MuleEvent)event));
        fields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)RESPONSE_TIMEOUT_DEBUG, Integer.class, (FieldDebugInfoFactory.FieldEvaluator)new FieldDebugInfoFactory.FieldEvaluator(){

            public Object evaluate() throws Exception {
                return DefaultHttpRequester.this.resolveResponseTimeout(event);
            }
        }));
        fields.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)QUERY_PARAMS_DEBUG, List.class, this.getQueryParamsDebugInfo(event)));
        fields.add(this.getSecurityFieldDebugInfo(event));
        return fields;
    }

    private List<FieldDebugInfo<?>> getQueryParamsDebugInfo(MuleEvent event) {
        ParameterMap queryParams = this.requestBuilder.getQueryParams(event);
        ArrayList params = new ArrayList();
        for (String paramName : queryParams.keySet()) {
            List<String> values = queryParams.getAll(paramName);
            if (values.size() == 1) {
                params.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)paramName, String.class, (Object)values.get(0)));
                continue;
            }
            params.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)paramName, List.class, values));
        }
        return params;
    }

    private FieldDebugInfo getSecurityFieldDebugInfo(MuleEvent event) {
        ErrorFieldDebugInfo securityFieldDebugInfo;
        try {
            HttpRequestAuthentication httpRequestAuthentication = this.resolveAuthentication(event);
            if (httpRequestAuthentication != null) {
                ArrayList<SimpleFieldDebugInfo> authenticationFields = new ArrayList<SimpleFieldDebugInfo>();
                authenticationFields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)USERNAME_DEBUG, String.class, (Object)httpRequestAuthentication.getUsername()));
                authenticationFields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)DOMAIN_DEBUG, String.class, (Object)httpRequestAuthentication.getDomain()));
                authenticationFields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)PASSWORD_DEBUG, String.class, (Object)httpRequestAuthentication.getPassword()));
                authenticationFields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)WORKSTATION_DEBUG, String.class, (Object)httpRequestAuthentication.getWorkstation()));
                authenticationFields.add(FieldDebugInfoFactory.createFieldDebugInfo((String)AUTHENTICATION_TYPE_DEBUG, String.class, (Object)httpRequestAuthentication.getType().name()));
                securityFieldDebugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)SECURITY_DEBUG, HttpRequestAuthentication.class, authenticationFields);
            } else {
                securityFieldDebugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)SECURITY_DEBUG, HttpRequestAuthentication.class, null);
            }
        }
        catch (Exception e) {
            securityFieldDebugInfo = FieldDebugInfoFactory.createFieldDebugInfo((String)SECURITY_DEBUG, HttpRequestAuthentication.class, (Exception)e);
        }
        return securityFieldDebugInfo;
    }
}

