/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener.grizzly;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.KeepAlive;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RoundRobinConnectionDistributor;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.WorkManagerSource;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.http.internal.HttpMessageLogger;
import org.mule.module.http.internal.listener.HttpListenerRegistry;
import org.mule.module.http.internal.listener.HttpServerManager;
import org.mule.module.http.internal.listener.Server;
import org.mule.module.http.internal.listener.ServerAddress;
import org.mule.module.http.internal.listener.grizzly.ExecutorPerServerAddressIOStrategy;
import org.mule.module.http.internal.listener.grizzly.GrizzlyAddressDelegateFilter;
import org.mule.module.http.internal.listener.grizzly.GrizzlyRequestDispatcherFilter;
import org.mule.module.http.internal.listener.grizzly.GrizzlyServer;
import org.mule.module.http.internal.listener.grizzly.MuleSslFilter;
import org.mule.module.http.internal.listener.grizzly.WorkManagerSourceExecutorProvider;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.transport.tcp.TcpServerSocketProperties;
import org.mule.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyServerManager
implements HttpServerManager {
    public static final String MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY = "mule.http.headerSectionSize";
    private static final int MAX_KEEP_ALIVE_REQUESTS = -1;
    private static final String IDLE_TIMEOUT_THREADS_PREFIX_NAME = ".HttpIdleConnectionCloser";
    private static final String LISTENER_WORKER_THREAD_NAME_SUFFIX = ".worker";
    private final GrizzlyAddressDelegateFilter<SSLFilter> sslFilterDelegate;
    private final GrizzlyAddressDelegateFilter<HttpServerFilter> httpServerFilterDelegate;
    private final TCPNIOTransport transport;
    private final GrizzlyRequestDispatcherFilter requestHandlerFilter;
    private final HttpListenerRegistry httpListenerRegistry;
    private final WorkManagerSourceExecutorProvider executorProvider;
    private Logger logger = LoggerFactory.getLogger(GrizzlyServerManager.class);
    private Map<ServerAddress, GrizzlyServer> servers = new ConcurrentHashMap<ServerAddress, GrizzlyServer>();
    private ExecutorService idleTimeoutExecutorService;
    private DelayedExecutor idleTimeoutDelayedExecutor;
    private boolean transportStarted;

    public GrizzlyServerManager(String threadNamePrefix, HttpListenerRegistry httpListenerRegistry, TcpServerSocketProperties serverSocketProperties) throws IOException {
        this.httpListenerRegistry = httpListenerRegistry;
        this.requestHandlerFilter = new GrizzlyRequestDispatcherFilter(httpListenerRegistry);
        this.sslFilterDelegate = new GrizzlyAddressDelegateFilter();
        this.httpServerFilterDelegate = new GrizzlyAddressDelegateFilter();
        FilterChainBuilder serverFilterChainBuilder = FilterChainBuilder.stateless();
        serverFilterChainBuilder.add((Filter)new TransportFilter());
        serverFilterChainBuilder.add(this.sslFilterDelegate);
        serverFilterChainBuilder.add(this.httpServerFilterDelegate);
        serverFilterChainBuilder.add((Filter)this.requestHandlerFilter);
        this.executorProvider = new WorkManagerSourceExecutorProvider();
        TCPNIOTransportBuilder transportBuilder = (TCPNIOTransportBuilder)((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setOptimizedForMultiplexing(true)).setIOStrategy((IOStrategy)new ExecutorPerServerAddressIOStrategy(this.executorProvider));
        this.configureServerSocketProperties(transportBuilder, serverSocketProperties);
        this.transport = transportBuilder.build();
        this.transport.setNIOChannelDistributor((NIOChannelDistributor)new RoundRobinConnectionDistributor((NIOTransport)this.transport, true, true));
        this.transport.getWorkerThreadPoolConfig().setPoolName(threadNamePrefix + LISTENER_WORKER_THREAD_NAME_SUFFIX);
        this.transport.setKernelThreadPoolConfig(ThreadPoolConfig.defaultConfig().setCorePoolSize(this.transport.getSelectorRunnersCount()).setMaxPoolSize(this.transport.getSelectorRunnersCount()).setPoolName(threadNamePrefix));
        this.transport.setProcessor((Processor)serverFilterChainBuilder.build());
        this.idleTimeoutExecutorService = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory(threadNamePrefix + IDLE_TIMEOUT_THREADS_PREFIX_NAME));
        this.idleTimeoutDelayedExecutor = new DelayedExecutor(this.idleTimeoutExecutorService);
    }

    private void configureServerSocketProperties(TCPNIOTransportBuilder transportBuilder, TcpServerSocketProperties serverSocketProperties) {
        if (serverSocketProperties.getKeepAlive() != null) {
            transportBuilder.setKeepAlive(serverSocketProperties.getKeepAlive().booleanValue());
        }
        if (serverSocketProperties.getLinger() != null) {
            transportBuilder.setLinger(serverSocketProperties.getLinger().intValue());
        }
        if (serverSocketProperties.getReuseAddress() != null) {
            transportBuilder.setReuseAddress(serverSocketProperties.getReuseAddress().booleanValue());
        }
        if (serverSocketProperties.getSendTcpNoDelay() != null) {
            transportBuilder.setTcpNoDelay(serverSocketProperties.getSendTcpNoDelay().booleanValue());
        }
        if (serverSocketProperties.getReceiveBacklog() != null) {
            transportBuilder.setServerConnectionBackLog(serverSocketProperties.getReceiveBacklog().intValue());
        }
        if (serverSocketProperties.getReceiveBufferSize() != null) {
            transportBuilder.setReadBufferSize(serverSocketProperties.getReceiveBufferSize().intValue());
        }
        if (serverSocketProperties.getSendBufferSize() != null) {
            transportBuilder.setWriteBufferSize(serverSocketProperties.getSendBufferSize().intValue());
        }
        if (serverSocketProperties.getServerTimeout() != null) {
            transportBuilder.setServerSocketSoTimeout(serverSocketProperties.getServerTimeout().intValue());
        }
        if (serverSocketProperties.getTimeout() != null) {
            transportBuilder.setClientSocketSoTimeout(serverSocketProperties.getTimeout().intValue());
        }
    }

    private void startTransportIfNotStarted() throws IOException {
        if (!this.transportStarted) {
            this.transportStarted = true;
            this.transport.start();
            this.idleTimeoutDelayedExecutor.start();
        }
    }

    @Override
    public boolean containsServerFor(ServerAddress serverAddress) {
        return this.servers.containsKey(serverAddress) || this.containsOverlappingServerFor(serverAddress);
    }

    private boolean containsOverlappingServerFor(ServerAddress newServerAddress) {
        for (ServerAddress serverAddress : this.servers.keySet()) {
            if (!serverAddress.overlaps(newServerAddress)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Server createSslServerFor(TlsContextFactory tlsContextFactory, WorkManagerSource workManagerSource, ServerAddress serverAddress, boolean usePersistentConnections, int connectionIdleTimeout) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating https server socket for ip {} and port {}", (Object)serverAddress.getIp(), (Object)serverAddress.getPort());
        }
        if (this.servers.containsKey(serverAddress)) {
            throw new IllegalStateException(String.format("Could not create a server for %s since there's already one.", serverAddress));
        }
        this.startTransportIfNotStarted();
        this.sslFilterDelegate.addFilterForAddress(serverAddress, this.createSslFilter(tlsContextFactory));
        this.httpServerFilterDelegate.addFilterForAddress(serverAddress, this.createHttpServerFilter(usePersistentConnections, connectionIdleTimeout));
        this.executorProvider.addExecutor(serverAddress, workManagerSource);
        GrizzlyServer grizzlyServer = new GrizzlyServer(serverAddress, this.transport, this.httpListenerRegistry);
        this.servers.put(serverAddress, grizzlyServer);
        return grizzlyServer;
    }

    @Override
    public Server createServerFor(ServerAddress serverAddress, WorkManagerSource workManagerSource, boolean usePersistentConnections, int connectionIdleTimeout) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating http server socket for ip {} and port {}", (Object)serverAddress.getIp(), (Object)serverAddress.getPort());
        }
        if (this.servers.containsKey(serverAddress)) {
            throw new IllegalStateException(String.format("Could not create a server for %s since there's already one.", serverAddress));
        }
        this.startTransportIfNotStarted();
        this.httpServerFilterDelegate.addFilterForAddress(serverAddress, this.createHttpServerFilter(usePersistentConnections, connectionIdleTimeout));
        this.executorProvider.addExecutor(serverAddress, workManagerSource);
        GrizzlyServer grizzlyServer = new GrizzlyServer(serverAddress, this.transport, this.httpListenerRegistry);
        this.servers.put(serverAddress, grizzlyServer);
        return grizzlyServer;
    }

    @Override
    public void dispose() {
        if (this.transportStarted) {
            this.transport.shutdown();
            this.servers.clear();
            this.idleTimeoutDelayedExecutor.destroy();
            this.idleTimeoutExecutorService.shutdown();
        }
    }

    private SSLFilter createSslFilter(TlsContextFactory tlsContextFactory) {
        try {
            String[] enabledCipherSuites;
            boolean clientAuth = tlsContextFactory.isTrustStoreConfigured();
            SSLEngineConfigurator serverConfig = new SSLEngineConfigurator(tlsContextFactory.createSslContext(), false, clientAuth, false);
            String[] enabledProtocols = tlsContextFactory.getEnabledProtocols();
            if (enabledProtocols != null) {
                serverConfig.setEnabledProtocols(enabledProtocols);
            }
            if ((enabledCipherSuites = tlsContextFactory.getEnabledCipherSuites()) != null) {
                serverConfig.setEnabledCipherSuites(enabledCipherSuites);
            }
            SSLEngineConfigurator clientConfig = serverConfig.copy().setClientMode(true);
            return new MuleSslFilter(serverConfig, clientConfig);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private HttpServerFilter createHttpServerFilter(boolean usePersistentConnections, int connectionIdleTimeout) {
        KeepAlive ka = null;
        if (usePersistentConnections) {
            ka = new KeepAlive();
            ka.setMaxRequestsCount(-1);
            ka.setIdleTimeoutInSeconds(this.convertToSeconds(connectionIdleTimeout));
        }
        HttpServerFilter httpServerFilter = new HttpServerFilter(true, this.retrieveMaximumHeaderSectionSize(), ka, this.idleTimeoutDelayedExecutor);
        httpServerFilter.getMonitoringConfig().addProbes((Object[])new HttpProbe[]{new HttpMessageLogger(HttpMessageLogger.LoggerType.LISTENER)});
        httpServerFilter.setAllowPayloadForUndefinedHttpMethods(true);
        return httpServerFilter;
    }

    private int retrieveMaximumHeaderSectionSize() {
        try {
            return Integer.valueOf(System.getProperty(MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY, String.valueOf(8192)));
        }
        catch (NumberFormatException e) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format("Invalid value %s for %s configuration", System.getProperty(MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY), MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY)), (Throwable)e);
        }
    }

    private int convertToSeconds(int milliseconds) {
        return (int)Math.ceil((double)milliseconds / 1000.0);
    }
}

