/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api;

import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.mule.extension.file.common.api.FileAttributes;
import org.mule.extension.file.common.api.FileConnectorConfig;
import org.mule.extension.file.common.api.FileSystem;
import org.mule.extension.file.common.api.FileWriteMode;
import org.mule.extension.file.common.api.exceptions.IllegalContentException;
import org.mule.extension.file.common.api.exceptions.IllegalPathException;
import org.mule.extension.file.common.api.matcher.FileMatcher;
import org.mule.extension.file.common.api.matcher.NullFilePayloadPredicate;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public abstract class BaseFileSystemOperations {
    private static final Integer LIST_PAGE_SIZE = 10;

    @Deprecated
    protected List<Result<InputStream, FileAttributes>> doList(FileConnectorConfig config, FileSystem fileSystem, String directoryPath, boolean recursive, FileMatcher matchWith) {
        fileSystem.changeToBaseDir();
        return fileSystem.list(config, directoryPath, recursive, this.getPredicate(matchWith));
    }

    protected List<Result<InputStream, FileAttributes>> doList(FileConnectorConfig config, FileSystem fileSystem, String directoryPath, boolean recursive, FileMatcher matchWith, Long timeBetweenSizeCheck) {
        fileSystem.changeToBaseDir();
        return fileSystem.list(config, directoryPath, recursive, this.getPredicate(matchWith), timeBetweenSizeCheck);
    }

    protected PagingProvider<FileSystem, Result<CursorProvider, FileAttributes>> doPagedList(final FileConnectorConfig config, final String directoryPath, final boolean recursive, final FileMatcher matchWith, final Long timeBetweenSizeCheck, final StreamingHelper streamingHelper) {
        return new PagingProvider<FileSystem, Result<CursorProvider, FileAttributes>>(){
            private List<Result<InputStream, FileAttributes>> files;
            private Iterator<Result<InputStream, FileAttributes>> filesIterator;
            private final AtomicBoolean initialised = new AtomicBoolean(false);

            public List<Result<CursorProvider, FileAttributes>> getPage(FileSystem connection) {
                if (this.initialised.compareAndSet(false, true)) {
                    this.initializePagingProvider(connection);
                }
                LinkedList<Result<CursorProvider, FileAttributes>> page = new LinkedList<Result<CursorProvider, FileAttributes>>();
                for (int i = 0; i < LIST_PAGE_SIZE && this.filesIterator.hasNext(); ++i) {
                    Result<InputStream, FileAttributes> result = this.filesIterator.next();
                    page.add((Result<CursorProvider, FileAttributes>)Result.builder().attributes(result.getAttributes().get()).output((Object)((CursorProvider)streamingHelper.resolveCursorProvider(result.getOutput()))).mediaType((MediaType)result.getMediaType().orElse(null)).attributesMediaType((MediaType)result.getAttributesMediaType().orElse(null)).build());
                }
                return page;
            }

            private void initializePagingProvider(FileSystem connection) {
                connection.changeToBaseDir();
                this.files = connection.list(config, directoryPath, recursive, BaseFileSystemOperations.this.getPredicate(matchWith), timeBetweenSizeCheck);
                this.filesIterator = this.files.iterator();
            }

            public Optional<Integer> getTotalResults(FileSystem connection) {
                return Optional.of(this.files.size());
            }

            public void close(FileSystem connection) throws MuleException {
            }
        };
    }

    @Deprecated
    protected Result<InputStream, FileAttributes> doRead(@Config FileConnectorConfig config, @Connection FileSystem fileSystem, @DisplayName(value="File Path") String path, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false") @Placement(tab="Advanced") boolean lock) {
        fileSystem.changeToBaseDir();
        return fileSystem.read(config, path, lock);
    }

    protected Result<InputStream, FileAttributes> doRead(@Config FileConnectorConfig config, @Connection FileSystem fileSystem, @DisplayName(value="File Path") String path, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false") @Placement(tab="Advanced") boolean lock, Long timeBetweenSizeCheck) {
        fileSystem.changeToBaseDir();
        return fileSystem.read(config, path, lock, timeBetweenSizeCheck);
    }

    @Deprecated
    protected void doWrite(FileConnectorConfig config, FileSystem fileSystem, String path, InputStream content, String encoding, boolean createParentDirectories, boolean lock, FileWriteMode mode) {
        if (content == null) {
            throw new IllegalContentException("Cannot write a null content");
        }
        this.validatePath(path, "path");
        fileSystem.changeToBaseDir();
        if (encoding == null) {
            encoding = config.getDefaultWriteEncoding();
        }
        fileSystem.write(path, content, mode, lock, createParentDirectories, encoding);
    }

    protected void doWrite(FileConnectorConfig config, FileSystem fileSystem, String path, InputStream content, boolean createParentDirectories, boolean lock, FileWriteMode mode) {
        if (content == null) {
            throw new IllegalContentException("Cannot write a null content");
        }
        this.validatePath(path, "path");
        fileSystem.changeToBaseDir();
        fileSystem.write(path, content, mode, lock, createParentDirectories);
    }

    protected void doCopy(FileConnectorConfig config, FileSystem fileSystem, String sourcePath, String targetPath, boolean createParentDirectories, boolean overwrite, String renameTo) {
        fileSystem.changeToBaseDir();
        this.validatePath(targetPath, "target path");
        this.validatePath(sourcePath, "source path");
        fileSystem.copy(config, sourcePath, targetPath, overwrite, createParentDirectories, renameTo);
    }

    protected void doMove(FileConnectorConfig config, FileSystem fileSystem, String sourcePath, String targetPath, boolean createParentDirectories, boolean overwrite, String renameTo) {
        fileSystem.changeToBaseDir();
        this.validatePath(targetPath, "target path");
        this.validatePath(sourcePath, "source path");
        fileSystem.move(config, sourcePath, targetPath, overwrite, createParentDirectories, renameTo);
    }

    protected void doDelete(FileSystem fileSystem, @org.mule.runtime.extension.api.annotation.param.Optional String path) {
        fileSystem.changeToBaseDir();
        fileSystem.delete(path);
    }

    protected void doRename(@Connection FileSystem fileSystem, @org.mule.runtime.extension.api.annotation.param.Optional String path, @DisplayName(value="New Name") String to, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false") boolean overwrite) {
        if (Paths.get(to, new String[0]).getNameCount() != 1) {
            throw new IllegalPathException(String.format("'to' parameter of rename operation should not contain any file separator character but '%s' was received", to));
        }
        fileSystem.changeToBaseDir();
        fileSystem.rename(path, to, overwrite);
    }

    protected void doCreateDirectory(@Connection FileSystem fileSystem, String directoryPath) {
        this.validatePath(directoryPath, "directory path");
        fileSystem.changeToBaseDir();
        fileSystem.createDirectory(directoryPath);
    }

    private void validatePath(String path, String pathName) {
        if (StringUtils.isBlank((String)path)) {
            throw new IllegalPathException(String.format("%s cannot be null nor blank", pathName));
        }
    }

    private Predicate<FileAttributes> getPredicate(FileMatcher builder) {
        return builder != null ? builder.build() : new NullFilePayloadPredicate<FileAttributes>();
    }
}

