/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.mule.extension.file.common.api.exceptions.IllegalPathException;
import org.mule.runtime.api.exception.MuleRuntimeException;

public final class UriUtils {
    private static String SEPARATOR = "/";

    private UriUtils() {
    }

    public static URI createUri(String path) {
        return UriUtils.createUri(path, "");
    }

    public static URI createUri(String basePath, String filePath) {
        try {
            String fullPath = filePath.length() > 0 ? (UriUtils.isAbsolute(filePath).booleanValue() ? filePath : UriUtils.addSeparator(basePath) + filePath) : UriUtils.removeSeparator(basePath);
            return new URI(null, null, fullPath, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalPathException("Cannot convert given path into a valid Uri", e);
        }
    }

    private static String addSeparator(String path) {
        return path.endsWith(SEPARATOR) || path.length() == 1 ? path : path + SEPARATOR;
    }

    private static String removeSeparator(String path) {
        return !path.endsWith(SEPARATOR) || path.length() == 1 ? path : path.substring(0, path.length() - 1);
    }

    private static Boolean isAbsolute(String path) {
        return path.length() > 0 && path.startsWith(SEPARATOR);
    }

    public static URI normalizeUri(URI uri) {
        URI normalizedUri = uri.normalize();
        String path = normalizedUri.getPath();
        if (path.endsWith(SEPARATOR)) {
            try {
                normalizedUri = new URI(null, null, path.substring(0, path.length() - 1), null).normalize();
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return normalizedUri;
    }

    public static URI trimLastFragment(URI uri) {
        Integer index = uri.getPath().lastIndexOf(SEPARATOR);
        return index != -1 ? UriUtils.createUri(uri.getPath().substring(0, index)) : null;
    }
}

