/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.source;

import java.nio.file.Paths;
import org.mule.extension.file.common.api.AbstractFileSystem;
import org.mule.extension.file.common.api.FileAttributes;
import org.mule.extension.file.common.api.FileConnectorConfig;
import org.mule.extension.file.common.api.exceptions.FileAlreadyExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPostActionGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPostActionGroup.class);

    public abstract boolean isAutoDelete();

    public abstract String getMoveToDirectory();

    public abstract String getRenameTo();

    public abstract boolean isApplyPostActionWhenFailed();

    public void validateSelf() throws IllegalArgumentException {
        if (this.isAutoDelete()) {
            if (this.getMoveToDirectory() != null) {
                throw new IllegalArgumentException(String.format("The autoDelete parameter was set to true, but the value '%s' was given to the moveToDirectory parameter. These two are contradictory.", this.getMoveToDirectory()));
            }
            if (this.getRenameTo() != null) {
                throw new IllegalArgumentException(String.format("The autoDelete parameter was set to true, but the value '%s' was given to the renameTo parameter. These two are contradictory.", this.getRenameTo()));
            }
        }
        if (this.getMoveToDirectory() == null && this.getRenameTo() != null) {
            throw new IllegalArgumentException(String.format("The value '%s' was given to the renameTo parameter, but the moveToDirectory parameter was not set. renameTo is only used to change the name to the file when it is moved to the moveToDirectory.", this.getRenameTo()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(AbstractFileSystem fileSystem, FileAttributes fileAttributes, FileConnectorConfig config) {
        if (LOGGER.isTraceEnabled()) {
            try {
                this.validateSelf();
            }
            catch (IllegalArgumentException e) {
                LOGGER.trace(e.getMessage());
            }
        }
        boolean moved = false;
        try {
            if (this.getMoveToDirectory() != null) {
                fileSystem.move(config, fileAttributes.getPath(), this.getMoveToDirectory(), false, true, this.getRenameTo());
                moved = true;
            }
        }
        catch (FileAlreadyExistsException e) {
            if (!this.isAutoDelete()) {
                String moveToFileName = this.getRenameTo() == null ? fileAttributes.getName() : this.getRenameTo();
                String moveToPath = Paths.get(this.getMoveToDirectory(), new String[0]).resolve(moveToFileName).toString();
                LOGGER.warn(String.format("A file with the same name was found when trying to move '%s' to '%s'. The file '%s' was not sent to the moveTo directory and it remains on the poll directory.", fileAttributes.getPath(), moveToPath, fileAttributes.getPath()));
                throw e;
            }
        }
        finally {
            if (this.isAutoDelete() && !moved) {
                fileSystem.delete(fileAttributes.getPath());
            }
        }
    }
}

