/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.EntityMetadataProvider;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.policy.OperationExecutionFunction;
import org.mule.runtime.core.policy.OperationPolicy;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.module.extension.internal.metadata.EntityMetadataMediator;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.ExecutionTypeMapper;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.LazyExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalOperationException;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.TargetReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.ValueReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.VoidReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OperationMessageProcessor
extends ExtensionComponent<OperationModel>
implements Processor,
EntityMetadataProvider,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationMessageProcessor.class);
    static final String INVALID_TARGET_MESSAGE = "Flow '%s' defines an invalid usage of operation '%s' which uses %s as target";
    private final ExtensionModel extensionModel;
    private final OperationModel operationModel;
    private final ComponentIdentifier operationIdentifier;
    private final ResolverSet resolverSet;
    private final String target;
    private final EntityMetadataMediator entityMetadataMediator;
    private ExecutionMediator executionMediator;
    private OperationExecutor operationExecutor;
    private PolicyManager policyManager;
    protected ReturnDelegate returnDelegate;

    public OperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, ResolverSet resolverSet, CursorStreamProviderFactory cursorStreamProviderFactory, ExtensionManager extensionManager, PolicyManager policyManager) {
        super(extensionModel, operationModel, configurationProvider, cursorStreamProviderFactory, extensionManager);
        this.extensionModel = extensionModel;
        this.operationModel = operationModel;
        this.resolverSet = resolverSet;
        this.target = target;
        this.entityMetadataMediator = new EntityMetadataMediator(operationModel);
        this.policyManager = policyManager;
        this.operationIdentifier = new ComponentIdentifier.Builder().withName(operationModel.getName()).withNamespace(extensionModel.getName().toLowerCase()).build();
    }

    public Event process(Event event) throws MuleException {
        try {
            return (Event)Mono.just((Object)event).transform((Function)((Object)this)).block();
        }
        catch (Exception e) {
            throw org.mule.runtime.core.api.rx.Exceptions.rxExceptionToMuleException((Throwable)e);
        }
    }

    public Publisher<Event> apply(Publisher<Event> publisher) {
        if (this.operationModel.isBlocking()) {
            return Flux.from(publisher).map(org.mule.runtime.core.api.rx.Exceptions.checkedFunction(event -> (Event)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> {
                Optional<ConfigurationInstance> configuration = this.getConfiguration((Event)event);
                Map<String, Object> operationParameters = this.resolverSet.resolve((Event)event).asMap();
                OperationExecutionFunction operationExecutionFunction = (parameters, operationEvent) -> {
                    ExecutionContextAdapter<OperationModel> operationContext = this.createExecutionContext(configuration, parameters, operationEvent);
                    return (Event)this.doProcess(operationEvent, operationContext).block();
                };
                OperationPolicy policy = this.policyManager.createOperationPolicy(this.operationIdentifier, event, operationParameters, operationExecutionFunction);
                return policy.process(event);
            }, MuleException.class, e -> {
                throw new DefaultMuleException((Throwable)e);
            })));
        }
        return Flux.from(publisher).flatMap(org.mule.runtime.core.api.rx.Exceptions.checkedFunction(event -> (Mono)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> {
            Optional<ConfigurationInstance> configuration = this.getConfiguration((Event)event);
            Map<String, Object> operationParameters = this.resolverSet.resolve((Event)event).asMap();
            ExecutionContextAdapter<OperationModel> operationContext = this.createExecutionContext(configuration, operationParameters, (Event)event);
            return this.doProcess((Event)event, operationContext).mapError(e -> !(e instanceof MessagingException), e -> new MessagingException(event, e, (Processor)this));
        }, MuleException.class, e -> {
            throw new DefaultMuleException((Throwable)e);
        })));
    }

    protected Mono<Event> doProcess(Event event, ExecutionContextAdapter operationContext) {
        return this.executeOperation(operationContext).map(value -> this.returnDelegate.asReturnValue(value, operationContext)).otherwiseIfEmpty(Mono.fromCallable(() -> this.returnDelegate.asReturnValue(null, operationContext))).mapError(Exceptions::unwrap);
    }

    private Mono<Object> executeOperation(ExecutionContextAdapter operationContext) {
        return Mono.from(this.executionMediator.execute(this.operationExecutor, operationContext));
    }

    private ExecutionContextAdapter<OperationModel> createExecutionContext(Optional<ConfigurationInstance> configuration, Map<String, Object> resolvedParameters, Event event) throws MuleException {
        return new DefaultExecutionContext<OperationModel>(this.extensionModel, configuration, resolvedParameters, this.operationModel, event, this.muleContext);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.returnDelegate = this.createReturnDelegate();
        this.operationExecutor = MuleExtensionUtils.getOperationExecutorFactory(this.operationModel).createExecutor(this.operationModel);
        this.executionMediator = this.createExecutionMediator();
        LifecycleUtils.initialiseIfNeeded((Object)this.operationExecutor, (boolean)true, (MuleContext)this.muleContext);
    }

    private ReturnDelegate createReturnDelegate() {
        if (IntrospectionUtils.isVoid((ComponentModel)this.operationModel)) {
            return VoidReturnDelegate.INSTANCE;
        }
        return !this.isTargetPresent() ? new ValueReturnDelegate((ComponentModel)this.operationModel, this.getCursorStreamProviderFactory(), this.muleContext) : new TargetReturnDelegate(this.target, (ComponentModel)this.operationModel, this.getCursorStreamProviderFactory(), this.muleContext);
    }

    private boolean isTargetPresent() {
        if (StringUtils.isBlank((String)this.target)) {
            return false;
        }
        if (this.target.startsWith("flowVars")) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.flowConstruct.getName(), this.operationModel.getName(), String.format("the '%s' prefix", "flowVars")));
        }
        if (this.muleContext.getExpressionManager().isExpression(this.target)) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.flowConstruct.getName(), this.operationModel.getName(), "an expression"));
        }
        return true;
    }

    @Override
    public void doStart() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.operationExecutor);
    }

    @Override
    public void doStop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.operationExecutor);
    }

    @Override
    public void doDispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.operationExecutor, (Logger)LOGGER);
    }

    public MetadataResult<MetadataKeysContainer> getEntityKeys() throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(this.extensionModel), () -> this.entityMetadataMediator.getEntityKeys((MetadataContext)context)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onKeys()});
        }
    }

    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(MetadataKey key) throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.entityMetadataMediator.getEntityMetadata((MetadataContext)context, key)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onKeys()});
        }
    }

    protected ExecutionMediator createExecutionMediator() {
        return new DefaultExecutionMediator(this.extensionModel, this.operationModel, this.connectionManager, this.muleContext.getErrorTypeRepository());
    }

    @Override
    protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
        ConfigurationModel configurationModel = configurationProvider.getConfigurationModel();
        if (!configurationModel.getOperationModel(this.operationModel.getName()).isPresent() && !configurationProvider.getExtensionModel().getOperationModel(this.operationModel.getName()).isPresent()) {
            throw new IllegalOperationException(String.format("Flow '%s' defines an usage of operation '%s' which points to configuration '%s'. The selected config does not support that operation.", this.flowConstruct.getName(), this.operationModel.getName(), configurationProvider.getName()));
        }
    }

    @Override
    protected ParameterValueResolver getParameterValueResolver() {
        Event event = MuleExtensionUtils.getInitialiserEvent(this.muleContext);
        return new OperationParameterValueResolver(new LazyExecutionContext<OperationModel>(this.resolverSet, this.operationModel, this.extensionModel, event));
    }

    public ReactiveProcessor.ProcessingType getProcessingType() {
        return ExecutionTypeMapper.asProcessingType(this.operationModel.getExecutionType());
    }

    public org.mule.runtime.api.component.ComponentIdentifier getIdentifier() {
        return new org.mule.runtime.api.component.ComponentIdentifier(){

            public String getNamespace() {
                return ((ComponentIdentifier)OperationMessageProcessor.this.getAnnotation(ComponentIdentifier.ANNOTATION_NAME)).getNamespace();
            }

            public String getName() {
                return ((ComponentIdentifier)OperationMessageProcessor.this.getAnnotation(ComponentIdentifier.ANNOTATION_NAME)).getName();
            }

            public ComponentIdentifier.ComponentType getComponentType() {
                return ComponentIdentifier.ComponentType.OPERATION;
            }
        };
    }
}

