/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.module.extension.internal.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.FieldWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class TypeWrapper
implements Type {
    private final Class<?> aClass;

    public TypeWrapper(Class<?> aClass) {
        this.aClass = aClass;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.aClass.getAnnotations();
    }

    @Override
    public String getName() {
        return this.aClass.getSimpleName();
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        return Optional.ofNullable(this.aClass.getAnnotation(annotationClass));
    }

    @Override
    public List<FieldElement> getFields() {
        return IntrospectionUtils.getFields(this.aClass).stream().map(FieldWrapper::new).collect(Collectors.toList());
    }

    @Override
    public List<FieldElement> getAnnotatedFields(Class<? extends Annotation> annotation) {
        return this.getFields().stream().filter(field -> field.isAnnotatedWith(annotation)).collect(Collectors.toList());
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.aClass;
    }
}

