/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.util.collection.ImmutableMapCollector;
import org.mule.runtime.extension.internal.property.QNameModelProperty;
import org.mule.runtime.module.extension.internal.xml.SchemaConstants;

public final class InfrastructureTypeMapping {
    private static Map<Class<?>, String> MAPPING = ImmutableMap.builder().put(TlsContextFactory.class, (Object)"tlsContext").build();
    private static Map<String, QNameModelProperty> QNAMES = ImmutableMap.builder().put((Object)"tlsContext", (Object)new QNameModelProperty(new QName(SchemaConstants.MULE_TLS_NAMESPACE, "context", "tls"))).build();
    private static Map<String, ParameterDslConfiguration> DSL_CONFIGURATIONS = ImmutableMap.builder().put((Object)"tlsContext", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(true).allowsReferences(true).build()).build();
    private static Map<String, String> nameMap = (Map)MAPPING.entrySet().stream().collect(new ImmutableMapCollector(e -> ((Class)e.getKey()).getName(), Map.Entry::getValue));

    public static Map<Class<?>, String> getMap() {
        return MAPPING;
    }

    public static Map<String, String> getNameMap() {
        return nameMap;
    }

    public static Optional<QNameModelProperty> getQName(String name) {
        return Optional.of(QNAMES.get(name));
    }

    public static Optional<ParameterDslConfiguration> getDslConfiguration(String name) {
        return Optional.of(DSL_CONFIGURATIONS.get(name));
    }

    private InfrastructureTypeMapping() {
    }
}

