/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.DeclaresExternalLibraries;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasSourceDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.ExternalLibs;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.RestrictedTo;
import org.mule.runtime.extension.api.annotation.dsl.xml.XmlHints;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.runtime.operation.ParameterResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.ConfigModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ConnectionProviderModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.OperationModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ParameterResolverTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.SourceModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.TypedValueTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.contributor.InfrastructureFieldContributor;
import org.mule.runtime.module.extension.internal.loader.java.contributor.ParameterDeclarerContributor;
import org.mule.runtime.module.extension.internal.loader.java.contributor.ParameterTypeUnwrapperContributor;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.DefaultEncodingModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.NullSafeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.TypeRestrictionModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionTypeFactory;
import org.mule.runtime.module.extension.internal.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.java.type.WithParameters;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.FieldWrapper;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class JavaModelLoaderDelegate {
    private final Class<?> extensionType;
    private final ClassTypeLoader typeLoader;
    private final String version;
    private final ConfigModelLoaderDelegate configLoaderDelegate = new ConfigModelLoaderDelegate(this);
    private final OperationModelLoaderDelegate operationLoaderDelegate = new OperationModelLoaderDelegate(this);
    private final SourceModelLoaderDelegate sourceModelLoaderDelegate = new SourceModelLoaderDelegate(this);
    private final ConnectionProviderModelLoaderDelegate connectionProviderModelLoaderDelegate = new ConnectionProviderModelLoaderDelegate(this);
    private List<ParameterDeclarerContributor> fieldParameterContributors;
    private List<ParameterDeclarerContributor> methodParameterContributors;

    public JavaModelLoaderDelegate(Class<?> extensionType, String version) {
        Preconditions.checkArgument((extensionType != null ? 1 : 0) != 0, (String)String.format("describer %s does not specify an extension type", this.getClass().getName()));
        this.extensionType = extensionType;
        this.version = version;
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(extensionType.getClassLoader());
        this.fieldParameterContributors = ImmutableList.of((Object)new InfrastructureFieldContributor(), (Object)new ParameterTypeUnwrapperContributor(this.typeLoader, TypedValue.class, new TypedValueTypeModelProperty()), (Object)new ParameterTypeUnwrapperContributor(this.typeLoader, ParameterResolver.class, new ParameterResolverTypeModelProperty()));
        this.methodParameterContributors = ImmutableList.of((Object)new ParameterTypeUnwrapperContributor(this.typeLoader, TypedValue.class, new TypedValueTypeModelProperty()), (Object)new ParameterTypeUnwrapperContributor(this.typeLoader, ParameterResolver.class, new ParameterResolverTypeModelProperty()));
    }

    public ExtensionDeclarer declare(ExtensionLoadingContext context) {
        ExtensionElement extensionElement = ExtensionTypeFactory.getExtensionType(this.extensionType);
        Extension extension = MuleExtensionAnnotationParser.getExtension(this.extensionType);
        ExtensionDeclarer declarer = context.getExtensionDeclarer().named(extension.name()).onVersion(this.version).fromVendor(extension.vendor()).withCategory(extension.category()).withMinMuleVersion(new MuleVersion(extension.minMuleVersion())).describedAs(extension.description()).withModelProperty((ModelProperty)new ImplementingTypeModelProperty(this.extensionType));
        this.parseExternalLibs(extensionElement, (DeclaresExternalLibraries)declarer);
        this.addExceptionEnricher(extensionElement, (HasModelProperties)declarer);
        this.configLoaderDelegate.declareConfigurations(declarer, extensionElement);
        this.connectionProviderModelLoaderDelegate.declareConnectionProviders((HasConnectionProviderDeclarer)declarer, extensionElement);
        if (!CollectionUtils.isEmpty(extensionElement.getConfigurations())) {
            this.operationLoaderDelegate.declareOperations(declarer, (HasOperationDeclarer)declarer, null, extensionElement.getOperations(), false);
            extensionElement.getSources().forEach(source -> this.sourceModelLoaderDelegate.declareMessageSource(declarer, (HasSourceDeclarer)declarer, (SourceElement)source, false));
        }
        return declarer;
    }

    protected void parseExternalLibs(WithAnnotations withAnnotations, DeclaresExternalLibraries declarer) {
        java.util.Optional<ExternalLibs> externalLibs = withAnnotations.getAnnotation(ExternalLibs.class);
        if (externalLibs.isPresent()) {
            Arrays.stream(externalLibs.get().value()).forEach(lib -> this.parseExternalLib(declarer, (ExternalLib)lib));
        } else {
            withAnnotations.getAnnotation(ExternalLib.class).ifPresent(lib -> this.parseExternalLib(declarer, (ExternalLib)lib));
        }
    }

    private void parseExternalLib(DeclaresExternalLibraries declarer, ExternalLib externalLibAnnotation) {
        ExternalLibraryModel.ExternalLibraryModelBuilder builder = ExternalLibraryModel.builder().withName(externalLibAnnotation.name()).withDescription(externalLibAnnotation.description());
        StringUtils.ifNotBlank((String)externalLibAnnotation.fileName(), arg_0 -> ((ExternalLibraryModel.ExternalLibraryModelBuilder)builder).withFileName(arg_0));
        StringUtils.ifNotBlank((String)externalLibAnnotation.requiredClassName(), arg_0 -> ((ExternalLibraryModel.ExternalLibraryModelBuilder)builder).withRequiredClassName(arg_0));
        declarer.withExternalLibrary(builder.build());
    }

    <M extends WithAnnotations> HasModelProperties addExceptionEnricher(M model, HasModelProperties declarer) {
        MuleExtensionAnnotationParser.getExceptionEnricherFactory(model).map(ExceptionHandlerModelProperty::new).ifPresent(arg_0 -> ((HasModelProperties)declarer).withModelProperty(arg_0));
        return declarer;
    }

    Class<?>[] getOperationClasses(Class<?> extensionType) {
        Operations operations = extensionType.getAnnotation(Operations.class);
        return operations == null ? ArrayUtils.EMPTY_CLASS_ARRAY : operations.value();
    }

    boolean isInvalidConfigSupport(boolean supportsConfig, java.util.Optional<ExtensionParameter> ... parameters) {
        return !supportsConfig && Stream.of(parameters).anyMatch(java.util.Optional::isPresent);
    }

    Declarer selectDeclarerBasedOnConfig(ExtensionDeclarer extensionDeclarer, Declarer declarer, java.util.Optional<ExtensionParameter> ... parameters) {
        for (java.util.Optional<ExtensionParameter> parameter : parameters) {
            if (!parameter.isPresent()) continue;
            return declarer;
        }
        return extensionDeclarer;
    }

    java.util.Optional<ExtensionParameter> getConfigParameter(WithParameters element) {
        return element.getParametersAnnotatedWith(UseConfig.class).stream().findFirst();
    }

    java.util.Optional<ExtensionParameter> getConnectionParameter(WithParameters element) {
        return element.getParametersAnnotatedWith(Connection.class).stream().findFirst();
    }

    List<ParameterDeclarer> declareFieldBasedParameters(ParameterizedDeclarer component, List<ExtensionParameter> parameters, ParameterDeclarationContext componentName) {
        return this.declareParameters(component, parameters, this.fieldParameterContributors, componentName, java.util.Optional.empty());
    }

    List<ParameterDeclarer> declareMethodBasedParameters(ParameterizedDeclarer component, List<ExtensionParameter> parameters, ParameterDeclarationContext componentName) {
        return this.declareParameters(component, parameters, this.methodParameterContributors, componentName, java.util.Optional.empty());
    }

    private List<ParameterDeclarer> declareParameters(ParameterizedDeclarer component, List<? extends ExtensionParameter> parameters, List<ParameterDeclarerContributor> contributors, ParameterDeclarationContext declarationContext, java.util.Optional<ParameterGroupDeclarer> parameterGroupDeclarer) {
        ArrayList<ParameterDeclarer> declarerList = new ArrayList<ParameterDeclarer>();
        this.checkAnnotationsNotUsedMoreThanOnce(parameters, Connection.class, UseConfig.class, MetadataKeyId.class);
        for (ExtensionParameter extensionParameter : parameters) {
            if (!extensionParameter.shouldBeAdvertised() || this.declaredAsGroup(component, contributors, declarationContext, extensionParameter)) continue;
            ParameterGroupDeclarer groupDeclarer = parameterGroupDeclarer.orElseGet(() -> ((ParameterizedDeclarer)component).onDefaultParameterGroup());
            Object parameter = extensionParameter.isRequired() ? groupDeclarer.withRequiredParameter(extensionParameter.getAlias()) : groupDeclarer.withOptionalParameter(extensionParameter.getAlias()).defaultingTo(extensionParameter.defaultValue().isPresent() ? extensionParameter.defaultValue().get() : null);
            parameter.ofType(extensionParameter.getMetadataType(this.typeLoader)).describedAs(extensionParameter.getDescription());
            this.parseParameterRole(extensionParameter, (ParameterDeclarer)parameter);
            this.parseExpressionSupport(extensionParameter, (ParameterDeclarer)parameter);
            this.parseNullSafe(extensionParameter, (ParameterDeclarer)parameter);
            this.parseDefaultEncoding(extensionParameter, (ParameterDeclarer)parameter);
            this.addTypeRestrictions(extensionParameter, (ParameterDeclarer)parameter);
            this.parseLayout(extensionParameter, (ParameterDeclarer)parameter);
            this.addImplementingTypeModelProperty(extensionParameter, (ParameterDeclarer)parameter);
            this.parseXmlHints(extensionParameter, (ParameterDeclarer)parameter);
            contributors.forEach(arg_0 -> JavaModelLoaderDelegate.lambda$declareParameters$3(extensionParameter, (ParameterDeclarer)parameter, declarationContext, arg_0));
            declarerList.add((ParameterDeclarer)parameter);
        }
        return declarerList;
    }

    private void parseDefaultEncoding(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        if (extensionParameter.getAnnotation(DefaultEncoding.class).isPresent()) {
            parameter.getDeclaration().setRequired(false);
            parameter.withModelProperty((ModelProperty)new DefaultEncodingModelProperty());
        }
    }

    private boolean declaredAsGroup(ParameterizedDeclarer component, List<ParameterDeclarerContributor> contributors, ParameterDeclarationContext declarationContext, ExtensionParameter groupParameter) throws IllegalParameterModelDefinitionException {
        ParameterGroup groupAnnotation = groupParameter.getAnnotation(ParameterGroup.class).orElse(null);
        if (groupAnnotation == null) {
            return false;
        }
        String groupName = groupAnnotation.name();
        if ("General".equals(groupName)) {
            throw new IllegalParameterModelDefinitionException(String.format("%s '%s' defines parameter group of name '%s' which is the default one. @%s cannot be used with the default group name", NameUtils.getComponentModelTypeName((Object)component), ((NamedDeclaration)component.getDeclaration()).getName(), groupName, ParameterGroup.class.getSimpleName()));
        }
        Type type = groupParameter.getType();
        List<FieldElement> nestedGroups = type.getAnnotatedFields(ParameterGroup.class);
        if (!nestedGroups.isEmpty()) {
            throw new IllegalParameterModelDefinitionException(String.format("Class '%s' is used as a @%s but contains fields which also hold that annotation. Nesting groups is not allowed. Offending fields are: [%s]", type.getName(), ParameterGroup.class.getSimpleName(), nestedGroups.stream().map(element -> element.getName()).collect(Collectors.joining(","))));
        }
        List<FieldElement> annotatedParameters = type.getAnnotatedFields(org.mule.runtime.extension.api.annotation.param.Parameter.class);
        if (groupParameter.isAnnotatedWith(Optional.class)) {
            throw new IllegalParameterModelDefinitionException(String.format("@%s can not be applied alongside with @%s. Affected parameter is [%s].", Optional.class.getSimpleName(), ParameterGroup.class.getSimpleName(), groupParameter.getName()));
        }
        ParameterGroupDeclarer declarer = component.onParameterGroup(groupName);
        if (declarer.getDeclaration().getModelProperty(ParameterGroupModelProperty.class).isPresent()) {
            throw new IllegalParameterModelDefinitionException(String.format("Parameter group '%s' has already been declared on %s '%s'", groupName, NameUtils.getComponentDeclarationTypeName((BaseDeclaration)component.getDeclaration()), ((NamedDeclaration)component.getDeclaration()).getName()));
        }
        declarer.withModelProperty((ModelProperty)new ParameterGroupModelProperty(new ParameterGroupDescriptor(groupName, type, groupParameter.getDeclaringElement())));
        type.getAnnotation(ExclusiveOptionals.class).ifPresent(annotation -> {
            Set optionalParamNames = annotatedParameters.stream().filter(f -> !f.isRequired()).map(f -> f.getName()).collect(Collectors.toSet());
            declarer.withExclusiveOptionals(optionalParamNames, annotation.isOneRequired());
        });
        declarer.withDslInlineRepresentation(groupAnnotation.showInDsl());
        MuleExtensionAnnotationParser.parseLayoutAnnotations(groupParameter, LayoutModel.builder()).ifPresent(arg_0 -> ((ParameterGroupDeclarer)declarer).withLayout(arg_0));
        if (!annotatedParameters.isEmpty()) {
            this.declareParameters(component, annotatedParameters, contributors, declarationContext, java.util.Optional.ofNullable(declarer));
        } else {
            this.declareParameters(component, IntrospectionUtils.getFieldsWithGetters(type.getDeclaringClass()).stream().map(FieldWrapper::new).collect(Collectors.toList()), contributors, declarationContext, java.util.Optional.ofNullable(declarer));
        }
        return true;
    }

    private void parseParameterRole(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        parameter.withRole(ExtensionModelUtils.roleOf(extensionParameter.getAnnotation(Content.class)));
    }

    private void parseExpressionSupport(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        java.util.Optional<Expression> annotation = extensionParameter.getAnnotation(Expression.class);
        if (annotation.isPresent()) {
            parameter.withExpressionSupport(IntrospectionUtils.getExpressionSupport(annotation.get()));
        }
    }

    private void parseNullSafe(final ExtensionParameter extensionParameter, final ParameterDeclarer parameter) {
        if (extensionParameter.isAnnotatedWith(NullSafe.class)) {
            if (extensionParameter.isRequired() && !extensionParameter.isAnnotatedWith(ParameterGroup.class)) {
                throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is required but annotated with '@%s', which is redundant", extensionParameter.getName(), NullSafe.class.getSimpleName()));
            }
            Class defaultType = extensionParameter.getAnnotation(NullSafe.class).get().defaultImplementingType();
            final boolean hasDefaultOverride = !defaultType.equals(Object.class);
            final MetadataType nullSafeType = hasDefaultOverride ? this.typeLoader.load((java.lang.reflect.Type)defaultType) : parameter.getDeclaration().getType();
            parameter.getDeclaration().getType().accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

                protected void visitBasicType(MetadataType metadataType) {
                    throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' but is of type '%s'. That annotation can only be used with complex types (Pojos, Lists, Maps)", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                }

                public void visitArrayType(ArrayType arrayType) {
                    if (hasDefaultOverride) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of type '%s' but a 'defaultImplementingType' was provided. Type override is not allowed for Collections", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                    }
                }

                public void visitObject(ObjectType objectType) {
                    if (hasDefaultOverride && ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of type '%s' but a 'defaultImplementingType' was provided. Type override is not allowed for Maps", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                    }
                    if (hasDefaultOverride && IntrospectionUtils.isInstantiable((MetadataType)objectType)) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of concrete type '%s', but a 'defaultImplementingType' was provided. Type override is not allowed for concrete types", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                    }
                    if (!IntrospectionUtils.isInstantiable(nullSafeType) && !ExtensionMetadataTypeUtils.isMap((MetadataType)nullSafeType)) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' but is of type '%s'. That annotation can only be used with complex instantiable types (Pojos, Lists, Maps)", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                    }
                    if (hasDefaultOverride && !JavaTypeUtils.getType((MetadataType)parameter.getDeclaration().getType()).isAssignableFrom(JavaTypeUtils.getType((MetadataType)nullSafeType))) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' of type '%s', but provided type '%s is not a subtype of the parameter's type", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName(), JavaTypeUtils.getType((MetadataType)nullSafeType).getName()));
                    }
                }
            });
            parameter.withModelProperty((ModelProperty)new NullSafeModelProperty(nullSafeType));
        }
    }

    private void parseLayout(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        MuleExtensionAnnotationParser.parseLayoutAnnotations(extensionParameter, LayoutModel.builder()).ifPresent(arg_0 -> ((ParameterDeclarer)parameter).withLayout(arg_0));
    }

    private void parseXmlHints(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        extensionParameter.getAnnotation(XmlHints.class).ifPresent(hints -> parameter.withDsl(ParameterDslConfiguration.builder().allowsInlineDefinition(hints.allowInlineDefinition()).allowsReferences(hints.allowReferences()).allowTopLevelDefinition(hints.allowTopLevelDefinition()).build()));
    }

    private void checkAnnotationsNotUsedMoreThanOnce(List<? extends ExtensionParameter> parameters, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            long count = parameters.stream().filter(param -> param.isAnnotatedWith(annotation)).count();
            if (count <= 1L) continue;
            throw new IllegalModelDefinitionException(String.format("The defined parameters %s from %s, uses the annotation @%s more than once", parameters.stream().map(p -> p.getName()).collect(Collectors.toList()), parameters.get(0).getOwnerDescription(), annotation.getSimpleName()));
        }
    }

    private void addTypeRestrictions(WithAnnotations withAnnotations, ParameterDeclarer parameter) {
        java.util.Optional<RestrictedTo> typeRestriction = withAnnotations.getAnnotation(RestrictedTo.class);
        if (typeRestriction.isPresent()) {
            parameter.withModelProperty(new TypeRestrictionModelProperty(typeRestriction.get().value()));
        }
    }

    private void addImplementingTypeModelProperty(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        AnnotatedElement element = extensionParameter.getDeclaringElement();
        parameter.withModelProperty((ModelProperty)(element instanceof Field ? new DeclaringMemberModelProperty((Field)element) : new ImplementingParameterModelProperty((Parameter)element)));
    }

    ConfigModelLoaderDelegate getConfigLoaderDelegate() {
        return this.configLoaderDelegate;
    }

    OperationModelLoaderDelegate getOperationLoaderDelegate() {
        return this.operationLoaderDelegate;
    }

    SourceModelLoaderDelegate getSourceModelLoaderDelegate() {
        return this.sourceModelLoaderDelegate;
    }

    ConnectionProviderModelLoaderDelegate getConnectionProviderModelLoaderDelegate() {
        return this.connectionProviderModelLoaderDelegate;
    }

    ClassTypeLoader getTypeLoader() {
        return this.typeLoader;
    }

    Class<?> getExtensionType() {
        return this.extensionType;
    }

    private static /* synthetic */ void lambda$declareParameters$3(ExtensionParameter extensionParameter, ParameterDeclarer parameter, ParameterDeclarationContext declarationContext, ParameterDeclarerContributor contributor) {
        contributor.contribute(extensionParameter, parameter, declarationContext);
    }
}

