/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.module.extension.internal.loader.AbstractInterceptable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InterceptableOperationExecutorWrapper
extends AbstractInterceptable
implements OperationExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterceptableOperationExecutorWrapper.class);
    private final OperationExecutor delegate;

    public InterceptableOperationExecutorWrapper(OperationExecutor delegate, List<Interceptor> interceptors) {
        super(interceptors);
        this.delegate = delegate;
    }

    public Publisher<Object> execute(ExecutionContext<OperationModel> executionContext) {
        return this.delegate.execute(executionContext);
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.delegate, (boolean)true, (MuleContext)this.muleContext);
        super.initialise();
    }

    @Override
    public void start() throws MuleException {
        super.start();
        LifecycleUtils.startIfNeeded((Object)this.delegate);
    }

    @Override
    public void stop() throws MuleException {
        super.stop();
        LifecycleUtils.stopIfNeeded((Object)this.delegate);
    }

    @Override
    public void dispose() {
        super.dispose();
        LifecycleUtils.disposeIfNeeded((Object)this.delegate, (Logger)LOGGER);
    }
}

