/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationInstanceNotification;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.lock.LockFactory;
import org.mule.runtime.core.api.retry.RetryCallback;
import org.mule.runtime.core.api.retry.RetryContext;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.time.TimeSupplier;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationStats;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.internal.loader.AbstractInterceptable;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultMutableConfigurationStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LifecycleAwareConfigurationInstance
extends AbstractInterceptable
implements ConfigurationInstance {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleAwareConfigurationInstance.class);
    private static final String DO_TEST_CONNECTIVITY_PROPERTY_NAME = "doTestConnectivity";
    private final String name;
    private final ConfigurationModel model;
    private final Object value;
    private final Optional<ConnectionProvider> connectionProvider;
    private ConfigurationStats configurationStats;
    @Inject
    private TimeSupplier timeSupplier;
    @Inject
    private MuleContext muleContext;
    @Inject
    private LockFactory lockFactory;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ConnectionManagerAdapter connectionManager;
    private Lock testConnectivityLock;
    private Scheduler retryScheduler;
    private volatile boolean initialized = false;
    private volatile boolean started = false;
    private boolean doTestConnectivity = this.getDoTestConnectivityProperty();

    public LifecycleAwareConfigurationInstance(String name, ConfigurationModel model, Object value, List<Interceptor> interceptors, Optional<ConnectionProvider> connectionProvider) {
        super(interceptors);
        this.name = name;
        this.model = model;
        this.value = value;
        this.connectionProvider = connectionProvider;
    }

    @Override
    public synchronized void initialise() throws InitialisationException {
        if (!this.initialized) {
            this.initialized = true;
            try {
                this.initStats();
                this.doInitialise();
                super.initialise();
            }
            catch (Exception e) {
                if (e instanceof InitialisationException) {
                    throw (InitialisationException)e;
                }
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    @Override
    public synchronized void start() throws MuleException {
        if (!this.started) {
            this.started = true;
            this.testConnectivityLock = this.lockFactory.createLock(this.getClass().getName() + "-testConnectivity-" + this.getName());
            if (this.connectionProvider.isPresent()) {
                LifecycleUtils.startIfNeeded(this.connectionProvider);
                if (!this.connectionManager.hasBinding(this.value)) {
                    this.connectionManager.bind(this.value, this.connectionProvider.get());
                }
                if (this.doTestConnectivity) {
                    this.testConnectivity();
                }
            }
            LifecycleUtils.startIfNeeded((Object)this.value);
            super.start();
        }
    }

    private void testConnectivity() throws MuleException {
        ConnectionProvider provider = this.connectionProvider.get();
        RetryPolicyTemplate retryTemplate = this.connectionManager.getRetryTemplateFor(provider);
        RetryCallback retryCallback = new RetryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doWork(RetryContext context) throws Exception {
                block5: {
                    boolean lockAcquired = LifecycleAwareConfigurationInstance.this.testConnectivityLock.tryLock();
                    if (lockAcquired) {
                        LOGGER.info("Doing testConnectivity() for config " + LifecycleAwareConfigurationInstance.this.getName());
                        try {
                            ConnectionValidationResult result = LifecycleAwareConfigurationInstance.this.connectionManager.testConnectivity((ConfigurationInstance)LifecycleAwareConfigurationInstance.this);
                            if (result.isValid()) {
                                context.setOk();
                                break block5;
                            }
                            context.setFailed((Throwable)result.getException());
                            throw new ConnectionException(String.format("Connectivity test failed for config '%s'", LifecycleAwareConfigurationInstance.this.getName()), (Throwable)result.getException());
                        }
                        finally {
                            LifecycleAwareConfigurationInstance.this.testConnectivityLock.unlock();
                        }
                    }
                    LOGGER.warn("There is a testConnectivity() already running for config " + LifecycleAwareConfigurationInstance.this.getName());
                }
            }

            public String getWorkDescription() {
                return String.format("Testing connectivity for config '%s'", LifecycleAwareConfigurationInstance.this.getName());
            }

            public Object getWorkOwner() {
                return LifecycleAwareConfigurationInstance.this.value;
            }
        };
        try {
            retryTemplate.execute(retryCallback, (Executor)this.retryScheduler);
        }
        catch (Exception e) {
            throw new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)String.format("Could not perform connectivity testing for config '%s'", this.getName())), (Throwable)e);
        }
    }

    @Override
    public synchronized void stop() throws MuleException {
        if (this.started) {
            this.started = false;
            try {
                LifecycleUtils.stopIfNeeded((Object)this.value);
                if (this.connectionProvider.isPresent()) {
                    this.testConnectivityLock.lock();
                    try {
                        this.connectionManager.unbind(this.value);
                        LifecycleUtils.stopIfNeeded(this.connectionProvider);
                    }
                    finally {
                        this.testConnectivityLock.unlock();
                    }
                }
                super.stop();
            }
            finally {
                this.muleContext.fireNotification((ServerNotification)new ConfigurationInstanceNotification((ConfigurationInstance)this, ConfigurationInstanceNotification.CONFIGURATION_STOPPED));
            }
        }
    }

    @Override
    public synchronized void dispose() {
        if (this.initialized) {
            this.initialized = false;
            if (this.retryScheduler != null) {
                this.retryScheduler.stop((long)this.muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS);
            }
            LifecycleUtils.disposeIfNeeded((Object)this.value, (Logger)LOGGER);
            LifecycleUtils.disposeIfNeeded(this.connectionProvider, (Logger)LOGGER);
            this.configurationStats = null;
            this.testConnectivityLock = null;
            super.dispose();
        }
    }

    private void doInitialise() throws InitialisationException {
        if (this.connectionProvider.isPresent()) {
            LifecycleUtils.initialiseIfNeeded(this.connectionProvider, (boolean)true, (MuleContext)this.muleContext);
            this.connectionManager.bind(this.value, this.connectionProvider.get());
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.value, (boolean)true, (MuleContext)this.muleContext);
        this.retryScheduler = this.schedulerService.ioScheduler();
    }

    public String getName() {
        return this.name;
    }

    public Optional<ConnectionProvider> getConnectionProvider() {
        return this.connectionProvider;
    }

    public ConfigurationModel getModel() {
        return this.model;
    }

    public Object getValue() {
        return this.value;
    }

    public ConfigurationStats getStatistics() {
        Preconditions.checkState((this.configurationStats != null ? 1 : 0) != 0, (String)"can't get statistics before initialise() is invoked");
        return this.configurationStats;
    }

    private void initStats() {
        if (this.timeSupplier == null) {
            this.timeSupplier = new TimeSupplier();
        }
        this.configurationStats = new DefaultMutableConfigurationStats(this.timeSupplier);
    }

    private boolean getDoTestConnectivityProperty() {
        return System.getProperty(DO_TEST_CONNECTIVITY_PROPERTY_NAME) != null ? Boolean.valueOf(System.getProperty(DO_TEST_CONNECTIVITY_PROPERTY_NAME)) : true;
    }
}

