/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.Pair;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.collection.ImmutableListCollector;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationStats;
import org.mule.runtime.extension.api.runtime.ExpirableConfigurationProvider;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationInstanceFactory;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicConfigurationProvider
extends LifecycleAwareConfigurationProvider
implements ExpirableConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicConfigurationProvider.class);
    private final ConfigurationInstanceFactory configurationInstanceFactory;
    private final ResolverSet resolverSet;
    private final ConnectionProviderValueResolver connectionProviderResolver;
    private final ExpirationPolicy expirationPolicy;
    private final Map<Pair<ResolverSetResult, ResolverSetResult>, ConfigurationInstance> cache = new ConcurrentHashMap<Pair<ResolverSetResult, ResolverSetResult>, ConfigurationInstance>();
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final Lock cacheReadLock = this.cacheLock.readLock();
    private final Lock cacheWriteLock = this.cacheLock.writeLock();

    public DynamicConfigurationProvider(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, ResolverSet resolverSet, ConnectionProviderValueResolver connectionProviderResolver, ExpirationPolicy expirationPolicy) {
        super(name, extensionModel, configurationModel);
        this.configurationInstanceFactory = new ConfigurationInstanceFactory(extensionModel, configurationModel, resolverSet);
        this.resolverSet = resolverSet;
        this.connectionProviderResolver = connectionProviderResolver;
        this.expirationPolicy = expirationPolicy;
    }

    public ConfigurationInstance get(Object event) {
        return (ConfigurationInstance)ClassUtils.withContextClassLoader((ClassLoader)this.getExtensionClassLoader(), () -> {
            ResolverSetResult result = this.resolverSet.resolve((Event)event);
            ResolverSetResult providerResult = null;
            if (this.connectionProviderResolver.getResolverSet().isPresent()) {
                providerResult = this.connectionProviderResolver.getResolverSet().get().resolve((Event)event);
            }
            return this.getConfiguration((Pair<ResolverSetResult, ResolverSetResult>)new Pair((Object)result, providerResult), (Event)event);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationInstance getConfiguration(Pair<ResolverSetResult, ResolverSetResult> resolverSetResult, Event event) throws Exception {
        ConfigurationInstance configuration;
        this.cacheReadLock.lock();
        try {
            configuration = this.cache.get(resolverSetResult);
            if (configuration != null) {
                this.updateUsageStatistic(configuration);
                ConfigurationInstance configurationInstance = configuration;
                return configurationInstance;
            }
        }
        finally {
            this.cacheReadLock.unlock();
        }
        this.cacheWriteLock.lock();
        try {
            configuration = this.cache.get(resolverSetResult);
            if (configuration == null) {
                configuration = this.createConfiguration((ResolverSetResult)resolverSetResult.getFirst(), event);
                this.cache.put(resolverSetResult, configuration);
            }
            this.updateUsageStatistic(configuration);
            ConfigurationInstance configurationInstance = configuration;
            return configurationInstance;
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    private void updateUsageStatistic(ConfigurationInstance configuration) {
        MutableConfigurationStats stats = (MutableConfigurationStats)configuration.getStatistics();
        stats.updateLastUsed();
    }

    private ConfigurationInstance createConfiguration(ResolverSetResult result, Event event) throws MuleException {
        ConfigurationInstance configuration = this.configurationInstanceFactory.createConfiguration(this.getName(), result, Optional.ofNullable(this.connectionProviderResolver.resolve(event)));
        this.registerConfiguration(configuration);
        return configuration;
    }

    @Override
    protected void registerConfiguration(ConfigurationInstance configuration) {
        try {
            ClassUtils.withContextClassLoader((ClassLoader)this.getExtensionClassLoader(), () -> {
                if (this.lifecycleManager.isPhaseComplete("initialise")) {
                    try {
                        LifecycleUtils.initialiseIfNeeded((Object)configuration, (boolean)true, (MuleContext)this.muleContext);
                    }
                    catch (Exception e) {
                        LifecycleUtils.disposeIfNeeded((Object)configuration, (Logger)LOGGER);
                        throw e;
                    }
                }
                if (this.lifecycleManager.isPhaseComplete("start")) {
                    try {
                        this.startConfig(configuration);
                    }
                    catch (Exception e) {
                        try {
                            LifecycleUtils.stopIfNeeded((Object)configuration);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Exception while stopping " + configuration.toString(), (Throwable)e);
                        }
                        LifecycleUtils.disposeIfNeeded((Object)configuration, (Logger)LOGGER);
                        throw e;
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not register configuration of key " + this.getName())), (Throwable)e);
        }
        super.registerConfiguration(configuration);
    }

    public List<ConfigurationInstance> getExpired() {
        this.cacheWriteLock.lock();
        try {
            List list = (List)this.cache.entrySet().stream().filter(entry -> this.isExpired((ConfigurationInstance)entry.getValue())).map(entry -> {
                this.cache.remove(entry.getKey());
                return (ConfigurationInstance)entry.getValue();
            }).collect(new ImmutableListCollector());
            return list;
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    private boolean isExpired(ConfigurationInstance configuration) {
        ConfigurationStats stats = configuration.getStatistics();
        return stats.getInflightOperations() == 0 && this.expirationPolicy.isExpired(stats.getLastUsedMillis(), TimeUnit.MILLISECONDS);
    }
}

