/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.EventedExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class LazyExecutionContext<M extends ComponentModel>
implements EventedExecutionContext<M> {
    private final Map<String, ValueResolver> valueResolvers;
    private final M componentModel;
    private final ExtensionModel extensionModel;
    private final Event event;

    public LazyExecutionContext(ResolverSet resolverSet, M componentModel, ExtensionModel extensionModel, Event event) {
        this.valueResolvers = resolverSet.getResolvers();
        this.componentModel = componentModel;
        this.extensionModel = extensionModel;
        this.event = event;
    }

    public boolean hasParameter(String parameterName) {
        return this.valueResolvers.containsKey(parameterName);
    }

    public <T> T getParameter(String parameterName) {
        if (this.hasParameter(parameterName)) {
            try {
                return this.valueResolvers.get(parameterName).resolve(this.event);
            }
            catch (MuleException e) {
                throw new RuntimeException(e);
            }
        }
        throw new NoSuchElementException();
    }

    public Optional<ConfigurationInstance> getConfiguration() {
        return Optional.empty();
    }

    @Override
    public Event getEvent() {
        return this.event;
    }

    public M getComponentModel() {
        return this.componentModel;
    }

    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }
}

