/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.manager;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.ServiceRegistry;
import org.mule.common.MuleVersion;
import org.mule.extension.introspection.Extension;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.extension.runtime.OperationContext;
import org.mule.module.extension.internal.introspection.DefaultExtensionFactory;
import org.mule.module.extension.internal.introspection.ExtensionDiscoverer;
import org.mule.module.extension.internal.manager.ConfigurationInstanceHolder;
import org.mule.module.extension.internal.manager.DefaultExtensionDiscoverer;
import org.mule.module.extension.internal.manager.DefaultImplicitConfigurationFactory;
import org.mule.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.module.extension.internal.manager.ExtensionRegistry;
import org.mule.module.extension.internal.manager.ExtensionStateTracker;
import org.mule.module.extension.internal.manager.ImplicitConfigurationFactory;
import org.mule.module.extension.internal.runtime.StaticConfigurationInstanceProvider;
import org.mule.registry.SpiServiceRegistry;
import org.mule.util.ObjectNameHelper;
import org.mule.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExtensionManager
implements ExtensionManagerAdapter,
MuleContextAware,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionManager.class);
    private final ExtensionRegistry extensionRegistry = new ExtensionRegistry();
    private final ServiceRegistry serviceRegistry = new SpiServiceRegistry();
    private MuleContext muleContext;
    private ObjectNameHelper objectNameHelper;
    private ExtensionDiscoverer extensionDiscoverer = new DefaultExtensionDiscoverer(new DefaultExtensionFactory(this.serviceRegistry), this.serviceRegistry);
    private ImplicitConfigurationFactory implicitConfigurationFactory;

    public void initialise() throws InitialisationException {
        this.objectNameHelper = new ObjectNameHelper(this.muleContext);
        this.implicitConfigurationFactory = new DefaultImplicitConfigurationFactory(this.extensionRegistry, this.muleContext);
    }

    public List<Extension> discoverExtensions(ClassLoader classLoader) {
        LOGGER.info("Starting discovery of extensions");
        List<Extension> discovered = this.extensionDiscoverer.discover(classLoader);
        LOGGER.info("Discovered {} extensions", (Object)discovered.size());
        for (Extension extension : discovered) {
            this.registerExtension(extension);
        }
        return ImmutableList.copyOf(this.extensionRegistry.getExtensions());
    }

    public boolean registerExtension(Extension extension) {
        LOGGER.info("Registering extension {} (version {})", (Object)extension.getName(), (Object)extension.getVersion());
        String extensionName = extension.getName();
        if (this.extensionRegistry.containsExtension(extensionName)) {
            return this.maybeUpdateExtension(extension, extensionName);
        }
        this.doRegisterExtension(extension, extensionName);
        return true;
    }

    public <C> void registerConfigurationInstanceProvider(Extension extension, String providerName, ConfigurationInstanceProvider<C> configurationInstanceProvider) {
        ExtensionStateTracker extensionStateTracker = this.extensionRegistry.getExtensionState(extension);
        extensionStateTracker.registerConfigurationInstanceProvider(providerName, configurationInstanceProvider);
    }

    @Override
    public <C> C getConfigurationInstance(Extension extension, String configurationInstanceProviderName, OperationContext operationContext) {
        ConfigurationInstanceProvider<C> configurationInstanceProvider = this.getConfigurationInstanceProvider(extension, configurationInstanceProviderName);
        return (C)configurationInstanceProvider.get(operationContext);
    }

    @Override
    public <C> C getConfigurationInstance(Extension extension, OperationContext operationContext) {
        List<ConfigurationInstanceProvider<?>> providers = this.extensionRegistry.getExtensionState(extension).getConfigurationInstanceProviders();
        int matches = providers.size();
        if (matches == 1) {
            ConfigurationInstanceProvider<?> provider = providers.get(0);
            return (C)provider.get(operationContext);
        }
        if (matches > 1) {
            throw new IllegalStateException(String.format("No config-ref was specified for operation '%s' of extension '%s', but %d are registered. Please specify which to use", operationContext.getOperation().getName(), extension.getName(), matches));
        }
        this.attemptToCreateImplicitConfigurationInstance(extension, operationContext);
        return this.getConfigurationInstance(extension, operationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptToCreateImplicitConfigurationInstance(Extension extension, OperationContext operationContext) {
        Extension extension2 = extension;
        synchronized (extension2) {
            ConfigurationInstanceHolder configurationInstanceHolder = this.implicitConfigurationFactory.createImplicitConfigurationInstance(extension, operationContext, this);
            if (configurationInstanceHolder != null) {
                this.registerConfigurationInstanceProvider(extension, configurationInstanceHolder.getName(), new StaticConfigurationInstanceProvider<Object>(configurationInstanceHolder.getConfigurationInstance()));
            }
        }
    }

    public Set<Extension> getExtensions() {
        return this.extensionRegistry.getExtensions();
    }

    public <C> Set<Extension> getExtensionsCapableOf(Class<C> capabilityType) {
        Preconditions.checkArgument((capabilityType != null ? 1 : 0) != 0, (String)"capability type cannot be null");
        return this.extensionRegistry.getExtensionsCapableOf(capabilityType);
    }

    public <C> void registerConfigurationInstance(Extension extension, String configurationInstanceName, C configurationInstance) {
        ExtensionStateTracker extensionStateTracker = this.extensionRegistry.getExtensionState(extension);
        configurationInstanceName = this.objectNameHelper.getUniqueName(configurationInstanceName);
        extensionStateTracker.registerConfigurationInstance(configurationInstanceName, configurationInstance);
        this.putInRegistryAndApplyLifecycle(configurationInstanceName, configurationInstance);
    }

    private void putInRegistryAndApplyLifecycle(String key, Object object) {
        try {
            this.muleContext.getRegistry().registerObject(key, object);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private <C> ConfigurationInstanceProvider<C> getConfigurationInstanceProvider(Extension extension, String configurationInstanceProviderName) {
        ConfigurationInstanceProvider configurationInstanceProvider = this.extensionRegistry.getExtensionState(extension).getConfigurationInstanceProvider(configurationInstanceProviderName);
        if (configurationInstanceProvider == null) {
            throw new IllegalArgumentException(String.format("There is no registered ConfigurationInstanceProvider under name '%s'", configurationInstanceProviderName));
        }
        return configurationInstanceProvider;
    }

    private boolean maybeUpdateExtension(Extension extension, String extensionName) {
        MuleVersion newVersion;
        Extension actual = this.extensionRegistry.getExtension(extensionName);
        try {
            newVersion = new MuleVersion(extension.getVersion());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn(String.format("Found extensions %s with invalid version %s. Skipping registration", extension.getName(), extension.getVersion()), (Throwable)e);
            return false;
        }
        if (newVersion.newerThan(actual.getVersion())) {
            this.logExtensionHotUpdate(extension, actual);
            this.doRegisterExtension(extension, extensionName);
            return true;
        }
        LOGGER.info("Found extension {} but version {} was already registered. Keeping existing definition", (Object)extension.getName(), (Object)extension.getVersion());
        return false;
    }

    private void doRegisterExtension(Extension extension, String extensionName) {
        this.extensionRegistry.registerExtension(extensionName, extension);
    }

    private void logExtensionHotUpdate(Extension extension, Extension actual) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Found extension %s which was already registered with version %s. New version %s was found. Hot updating extension definition", extension.getName(), actual.getVersion(), extension.getVersion()));
        }
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    void setExtensionsDiscoverer(ExtensionDiscoverer discoverer) {
        this.extensionDiscoverer = discoverer;
    }
}

