/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.manager;

import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Parameter;
import org.mule.extension.runtime.ConfigurationInstanceRegistrationCallback;
import org.mule.extension.runtime.OperationContext;
import org.mule.module.extension.internal.manager.ConfigurationInstanceHolder;
import org.mule.module.extension.internal.manager.ExtensionRegistry;
import org.mule.module.extension.internal.manager.ImplicitConfigurationFactory;
import org.mule.module.extension.internal.runtime.ConfigurationObjectBuilder;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.module.extension.internal.util.MuleExtensionUtils;

final class DefaultImplicitConfigurationFactory
implements ImplicitConfigurationFactory {
    private final MuleContext muleContext;
    private final ExtensionRegistry extensionRegistry;

    protected DefaultImplicitConfigurationFactory(ExtensionRegistry extensionRegistry, MuleContext muleContext) {
        this.extensionRegistry = extensionRegistry;
        this.muleContext = muleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationInstanceHolder createImplicitConfigurationInstance(Extension extension, OperationContext operationContext, ConfigurationInstanceRegistrationCallback registrationCallback) {
        Configuration implicitConfiguration = this.getImplicitConfiguration(extension);
        if (implicitConfiguration == null) {
            throw new IllegalStateException(String.format("Could not find a config for extension '%s' and none can be created automatically. Please define one", extension.getName()));
        }
        Configuration configuration = implicitConfiguration;
        synchronized (configuration) {
            Object configurationInstance;
            if (!this.extensionRegistry.getExtensionState(extension).getConfigurationInstanceProviders().isEmpty()) {
                return null;
            }
            String instanceName = String.format("%s-%s", extension.getName(), implicitConfiguration.getName());
            ConfigurationObjectBuilder configurationObjectBuilder = new ConfigurationObjectBuilder(instanceName, extension, implicitConfiguration, this.buildImplicitConfigurationResolverSet(implicitConfiguration), registrationCallback);
            try {
                configurationInstance = configurationObjectBuilder.build(MuleExtensionUtils.asOperationContextAdapter(operationContext).getEvent());
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            return new ConfigurationInstanceHolder(instanceName, configurationInstance);
        }
    }

    private ResolverSet buildImplicitConfigurationResolverSet(Configuration configuration) {
        ResolverSet resolverSet = new ResolverSet();
        for (Parameter parameter : configuration.getParameters()) {
            Object defaultValue = parameter.getDefaultValue();
            if (defaultValue == null) continue;
            ValueResolver<Object> valueResolver = defaultValue instanceof String && this.muleContext.getExpressionManager().isExpression((String)defaultValue) ? new TypeSafeExpressionValueResolver((String)defaultValue, parameter.getType()) : new StaticValueResolver<Object>(defaultValue);
            resolverSet.add(parameter, valueResolver);
        }
        return resolverSet;
    }

    private Configuration getImplicitConfiguration(Extension extension) {
        for (Configuration configuration : extension.getConfigurations()) {
            if (!this.canBeUsedImplicitly(configuration)) continue;
            return configuration;
        }
        return null;
    }

    private boolean canBeUsedImplicitly(Configuration configuration) {
        for (Parameter parameter : configuration.getParameters()) {
            if (!parameter.isRequired() || parameter.getDefaultValue() != null) continue;
            return false;
        }
        return true;
    }
}

