/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.introspection;

import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.Parameter;
import org.mule.module.extension.internal.introspection.AbstractCapableDescribed;
import org.mule.util.Preconditions;

final class ImmutableParameter
extends AbstractCapableDescribed
implements Parameter {
    private final DataType type;
    private final boolean required;
    private final boolean dynamic;
    private final Object defaultValue;

    protected ImmutableParameter(String name, String description, DataType type, boolean required, boolean dynamic, Object defaultValue, Set<Object> capabilities) {
        super(name, description, capabilities);
        if (RESERVED_NAMES.contains(name)) {
            throw new IllegalArgumentException(String.format("Extension parameter cannot have the name ['%s'] since it's a reserved one", name));
        }
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Extension parameters must have a type");
        if (required && defaultValue != null) {
            throw new IllegalStateException("A required Extension parameter cannot have a default value");
        }
        this.type = type;
        this.required = required;
        this.dynamic = dynamic;
        this.defaultValue = defaultValue;
    }

    public DataType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

