/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.manager;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.extension.introspection.Operation;
import org.mule.extension.runtime.OperationExecutor;
import org.mule.util.Preconditions;
import org.mule.util.StringUtils;

public final class ConfigurationInstanceWrapper<C> {
    private final String name;
    private final C configurationInstance;
    private final ConcurrentMap<Operation, OperationExecutor> executors = new ConcurrentHashMap<Operation, OperationExecutor>();

    public ConfigurationInstanceWrapper(String name, C configurationInstance) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)name) ? 1 : 0) != 0, (String)"name cannot be empty");
        Preconditions.checkArgument((configurationInstance != null ? 1 : 0) != 0, (String)"configurationInstance cannot be null");
        this.name = name;
        this.configurationInstance = configurationInstance;
    }

    OperationExecutor getOperationExecutor(Operation operation) {
        return (OperationExecutor)this.executors.get(operation);
    }

    C getConfigurationInstance() {
        return this.configurationInstance;
    }

    void registerOperationExecutor(Operation operation, OperationExecutor executor) {
        if (this.executors.putIfAbsent(operation, executor) != null) {
            throw new IllegalStateException(String.format("An operation executor was already registered for operation %s on configuration instance %s", operation.getName(), this.getName()));
        }
    }

    String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConfigurationInstanceWrapper) {
            return this.configurationInstance == ((ConfigurationInstanceWrapper)obj).configurationInstance;
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this.configurationInstance);
    }
}

