/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema;

import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.core.util.annotation.AnnotationUtils;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

class ClasspathBasedDslContext
implements DslResolvingContext {
    private final ClassLoader classLoader;
    private final Map<String, Class<?>> extensionsByName = new HashMap();
    private final Map<String, ExtensionModel> resolvedModels = new HashMap<String, ExtensionModel>();
    private TypeCatalog typeCatalog;

    ClasspathBasedDslContext(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.findExtensionsInClasspath();
    }

    public Optional<ExtensionModel> getExtension(String name) {
        if (!this.resolvedModels.containsKey(name) && this.extensionsByName.containsKey(name)) {
            this.resolvedModels.put(name, MuleExtensionUtils.loadExtension(this.extensionsByName.get(name)));
        }
        return Optional.ofNullable(this.resolvedModels.get(name));
    }

    public Set<ExtensionModel> getExtensions() {
        return this.resolvedModels.size() != this.extensionsByName.size() ? this.extensionsByName.values().stream().map(MuleExtensionUtils::loadExtension).collect(Collectors.toSet()) : ImmutableSet.copyOf(this.resolvedModels.values());
    }

    public TypeCatalog getTypeCatalog() {
        if (this.typeCatalog == null) {
            this.typeCatalog = TypeCatalog.getDefault((Set)this.getExtensions());
        }
        return this.typeCatalog;
    }

    private void findExtensionsInClasspath() {
        Collection mulePluginsUrls = ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{this.classLoader}).stream().filter(url -> url.getFile().contains("mule-plugin")).collect(Collectors.toList());
        Set<Class<?>> annotated = this.getExtensionTypes(mulePluginsUrls);
        annotated.forEach(type -> AnnotationUtils.getAnnotation((Class)type, Extension.class).ifPresent(extension -> this.extensionsByName.put(extension.name(), (Class<?>)type)));
    }

    private Set<Class<?>> getExtensionTypes(Collection<URL> urls) {
        try {
            return new Reflections((Configuration)new ConfigurationBuilder().setUrls(urls).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()})).getTypesAnnotatedWith(Extension.class);
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }
}

