/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.operation;

import java.util.function.Predicate;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.extension.api.model.property.PagedOperationModelProperty;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.runtime.module.extension.internal.model.property.InterceptingModelProperty;
import org.mule.runtime.module.extension.internal.runtime.operation.InterceptingOperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.PagedOperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class OperationMessageProcessorObjectFactory
extends AbstractExtensionObjectFactory<OperationMessageProcessor> {
    private final ExtensionModel extensionModel;
    private final OperationModel operationModel;
    private final PolicyManager policyManager;
    private ConfigurationProvider configurationProvider;
    private String target = "";

    public OperationMessageProcessorObjectFactory(ExtensionModel extensionModel, OperationModel operationModel, MuleContext muleContext, PolicyManager policyManager) {
        super(muleContext);
        this.extensionModel = extensionModel;
        this.operationModel = operationModel;
        this.policyManager = policyManager;
    }

    public OperationMessageProcessor doGetObject() throws Exception {
        return (OperationMessageProcessor)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader((ExtensionModel)this.extensionModel), () -> {
            try {
                ResolverSet resolverSet = this.getParametersAsResolverSet((ParameterizedModel)this.operationModel, new Predicate[0]);
                OperationMessageProcessor processor = this.createMessageProcessor(resolverSet);
                this.muleContext.getInjector().inject((Object)processor);
                return processor;
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
    }

    private OperationMessageProcessor createMessageProcessor(ResolverSet resolverSet) {
        if (this.operationModel.getModelProperty(InterceptingModelProperty.class).isPresent()) {
            return new InterceptingOperationMessageProcessor(this.extensionModel, this.operationModel, this.configurationProvider, this.target, resolverSet, (ExtensionManagerAdapter)this.muleContext.getExtensionManager(), this.policyManager);
        }
        if (this.operationModel.getModelProperty(PagedOperationModelProperty.class).isPresent()) {
            return new PagedOperationMessageProcessor(this.extensionModel, this.operationModel, this.configurationProvider, this.target, resolverSet, (ExtensionManagerAdapter)this.muleContext.getExtensionManager(), this.policyManager);
        }
        return new OperationMessageProcessor(this.extensionModel, this.operationModel, this.configurationProvider, this.target, resolverSet, (ExtensionManagerAdapter)this.muleContext.getExtensionManager(), this.policyManager);
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

