/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.extension.api.util.SubTypesMappingContainer;

public class ExtensionParsingContext {
    private final Map<String, MetadataType> parsedObjectTypes = new HashMap<String, MetadataType>();
    private Optional<SubTypesMappingContainer> subTypesMapping = Optional.empty();

    public boolean registerObjectType(String name, String namespace, ObjectType type) {
        return this.parsedObjectTypes.put(this.generateObjectKey(name, namespace), (MetadataType)type) == null;
    }

    public boolean isRegistered(String name, String namespace) {
        return this.parsedObjectTypes.containsKey(this.generateObjectKey(name, namespace));
    }

    public Collection<MetadataType> getSubTypes(MetadataType type) {
        return this.subTypesMapping.map(mapping -> mapping.getSubTypes(type)).orElse((Collection)ImmutableList.of());
    }

    public void setSubTypesMapping(SubTypesMappingContainer subTypesMapping) {
        this.subTypesMapping = Optional.ofNullable(subTypesMapping);
    }

    public List<MetadataType> getAllBaseTypes() {
        return this.subTypesMapping.map(SubTypesMappingContainer::getAllBaseTypes).orElse((List)ImmutableList.of());
    }

    public List<MetadataType> getAllSubTypes() {
        return this.subTypesMapping.map(SubTypesMappingContainer::getAllSubTypes).orElse((List)ImmutableList.of());
    }

    private String generateObjectKey(String name, String namespace) {
        return name + namespace;
    }
}

