/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl;

import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.internal.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.NestedProcessor;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.util.TemplateParser;
import org.mule.runtime.core.util.ValueHolder;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.xml.dsl.api.DslElementSyntax;
import org.mule.runtime.extension.xml.dsl.api.resolver.DslSyntaxResolver;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.object.CharsetValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.DefaultObjectParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.DefaultValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.FixedTypeParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.MediaTypeValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.ObjectParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.ParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.ValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.ObjectTypeParameterParser;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.TopLevelParameterObjectFactory;
import org.mule.runtime.module.extension.internal.introspection.describer.FunctionParameterTypeModelProperty;
import org.mule.runtime.module.extension.internal.introspection.describer.ParameterResolverTypeModelProperty;
import org.mule.runtime.module.extension.internal.model.property.QueryParameterModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedParameterResolverValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionFunctionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.NativeQueryParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.NestedProcessorListValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.NestedProcessorValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;

public abstract class ExtensionDefinitionParser {
    static final String CHILD_ELEMENT_KEY_PREFIX = "<<";
    static final String CHILD_ELEMENT_KEY_SUFFIX = ">>";
    protected static final String CONFIG_PROVIDER_ATTRIBUTE_NAME = "configurationProvider";
    protected final ExtensionParsingContext parsingContext;
    protected final List<ObjectParsingDelegate> objectParsingDelegates = ImmutableList.of((Object)new FixedTypeParsingDelegate(PoolingProfile.class), (Object)new FixedTypeParsingDelegate(RetryPolicyTemplate.class), (Object)new FixedTypeParsingDelegate(TlsContextFactory.class), (Object)new DefaultObjectParsingDelegate());
    protected final DslSyntaxResolver dslResolver;
    protected final ComponentBuildingDefinition.Builder baseDefinitionBuilder;
    private final TemplateParser parser = TemplateParser.createMuleStyleParser();
    private final ConversionService conversionService = new DefaultConversionService();
    private final Map<String, AttributeDefinition.Builder> parameters = new HashMap<String, AttributeDefinition.Builder>();
    private final List<ComponentBuildingDefinition> parsedDefinitions = new ArrayList<ComponentBuildingDefinition>();
    private final List<ValueResolverParsingDelegate> valueResolverParsingDelegates = ImmutableList.of((Object)new CharsetValueResolverParsingDelegate(), (Object)new MediaTypeValueResolverParsingDelegate());
    private final ValueResolverParsingDelegate defaultValueResolverParsingDelegate = new DefaultValueResolverParsingDelegate();
    protected final MuleContext muleContext;

    protected ExtensionDefinitionParser(ComponentBuildingDefinition.Builder baseDefinitionBuilder, DslSyntaxResolver dslSyntaxResolver, ExtensionParsingContext parsingContext, MuleContext muleContext) {
        this.baseDefinitionBuilder = baseDefinitionBuilder;
        this.dslResolver = dslSyntaxResolver;
        this.parsingContext = parsingContext;
        this.muleContext = muleContext;
    }

    public final List<ComponentBuildingDefinition> parse() throws ConfigurationException {
        ComponentBuildingDefinition.Builder builder = this.baseDefinitionBuilder.copy();
        this.doParse(builder);
        AttributeDefinition parametersDefinition = AttributeDefinition.Builder.fromFixedValue(new HashMap()).build();
        if (!this.parameters.isEmpty()) {
            KeyAttributeDefinitionPair[] attributeDefinitions = (KeyAttributeDefinitionPair[])this.parameters.entrySet().stream().map(entry -> KeyAttributeDefinitionPair.newBuilder().withAttributeDefinition(((AttributeDefinition.Builder)entry.getValue()).build()).withKey((String)entry.getKey()).build()).toArray(KeyAttributeDefinitionPair[]::new);
            parametersDefinition = AttributeDefinition.Builder.fromMultipleDefinitions((KeyAttributeDefinitionPair[])attributeDefinitions).build();
        }
        builder.withSetterParameterDefinition("parameters", parametersDefinition);
        this.addDefinition(builder.build());
        return this.parsedDefinitions;
    }

    protected abstract void doParse(ComponentBuildingDefinition.Builder var1) throws ConfigurationException;

    protected void parseParameters(List<ParameterModel> parameters) {
        parameters.forEach(parameter -> {
            DslElementSyntax paramDsl = this.dslResolver.resolve(parameter);
            boolean isContent = ExtensionModelUtils.isContent((ParameterModel)parameter);
            parameter.getType().accept(new MetadataTypeVisitor((ParameterModel)parameter, paramDsl, isContent){
                final /* synthetic */ ParameterModel val$parameter;
                final /* synthetic */ DslElementSyntax val$paramDsl;
                final /* synthetic */ boolean val$isContent;
                {
                    this.val$parameter = parameterModel;
                    this.val$paramDsl = dslElementSyntax;
                    this.val$isContent = bl;
                }

                protected void defaultVisit(MetadataType metadataType) {
                    ExtensionDefinitionParser.this.parseAttributeParameter(this.val$parameter);
                }

                public void visitString(StringType stringType) {
                    if (this.val$paramDsl.supportsChildDeclaration()) {
                        ExtensionDefinitionParser.this.parseFromTextExpression(this.val$parameter, this.val$paramDsl, () -> {
                            Optional query = this.val$parameter.getModelProperty(QueryParameterModelProperty.class);
                            if (query.isPresent()) {
                                return value -> new NativeQueryParameterValueResolver((String)value, ((QueryParameterModelProperty)query.get()).getQueryTranslator());
                            }
                            return value -> ExtensionDefinitionParser.this.resolverOf(this.val$parameter.getName(), (MetadataType)stringType, value, this.val$parameter.getDefaultValue(), this.val$parameter.getExpressionSupport(), this.val$parameter.isRequired(), this.val$parameter.getModelProperties(), ExtensionDefinitionParser.this.acceptsReferences(this.val$parameter));
                        });
                    } else {
                        this.defaultVisit((MetadataType)stringType);
                    }
                }

                public void visitObject(ObjectType objectType) {
                    if (this.isNestedProcessor((MetadataType)objectType)) {
                        ExtensionDefinitionParser.this.parseNestedProcessor(this.val$parameter);
                    } else if (!ExtensionDefinitionParser.this.parsingContext.isRegistered(this.val$paramDsl.getElementName(), this.val$paramDsl.getNamespace())) {
                        ExtensionDefinitionParser.this.parsingContext.registerObjectType(this.val$paramDsl.getElementName(), this.val$paramDsl.getNamespace(), objectType);
                        ExtensionDefinitionParser.this.parseObjectParameter(this.val$parameter, this.val$paramDsl);
                    } else {
                        ExtensionDefinitionParser.this.parseObject(ExtensionDefinitionParser.this.getKey(this.val$parameter), this.val$parameter.getName(), objectType, this.val$parameter.getDefaultValue(), this.val$parameter.getExpressionSupport(), this.val$parameter.isRequired(), ExtensionDefinitionParser.this.acceptsReferences(this.val$parameter), this.val$paramDsl, this.val$parameter.getModelProperties());
                    }
                }

                public void visitDictionary(DictionaryType dictionaryType) {
                    if (!this.parseAsContent((MetadataType)dictionaryType)) {
                        ExtensionDefinitionParser.this.parseMapParameters(this.val$parameter, dictionaryType, this.val$paramDsl);
                    }
                }

                public void visitArrayType(ArrayType arrayType) {
                    if (this.isNestedProcessor(arrayType.getType())) {
                        ExtensionDefinitionParser.this.parseNestedProcessorList(this.val$parameter);
                    } else if (!this.parseAsContent((MetadataType)arrayType)) {
                        ExtensionDefinitionParser.this.parseCollectionParameter(this.val$parameter, arrayType, this.val$paramDsl);
                    }
                }

                private boolean parseAsContent(MetadataType type) {
                    if (this.val$isContent) {
                        ExtensionDefinitionParser.this.parseFromTextExpression(this.val$parameter, this.val$paramDsl, () -> value -> ExtensionDefinitionParser.this.resolverOf(this.val$parameter.getName(), type, value, this.val$parameter.getDefaultValue(), this.val$parameter.getExpressionSupport(), this.val$parameter.isRequired(), this.val$parameter.getModelProperties(), ExtensionDefinitionParser.this.acceptsReferences(this.val$parameter)));
                        return true;
                    }
                    return false;
                }

                private boolean isNestedProcessor(MetadataType type) {
                    return NestedProcessor.class.isAssignableFrom(JavaTypeUtils.getType((MetadataType)type));
                }
            });
        });
    }

    protected void parseMapParameters(ParameterModel parameter, DictionaryType dictionaryType, DslElementSyntax paramDsl) {
        this.parseMapParameters(this.getKey(parameter), parameter.getName(), dictionaryType, parameter.getDefaultValue(), parameter.getExpressionSupport(), parameter.isRequired(), paramDsl, parameter.getModelProperties());
    }

    protected void parseMapParameters(String key, String name, DictionaryType dictionaryType, Object defaultValue, final ExpressionSupport expressionSupport, boolean required, DslElementSyntax paramDsl, final Set<ModelProperty> modelProperties) {
        this.parseAttributeParameter(key, name, (MetadataType)dictionaryType, defaultValue, expressionSupport, required, modelProperties);
        Class mapType = JavaTypeUtils.getType((MetadataType)dictionaryType);
        if (ConcurrentMap.class.equals((Object)mapType)) {
            mapType = ConcurrentHashMap.class;
        } else if (Map.class.equals(mapType)) {
            mapType = LinkedHashMap.class;
        }
        final MetadataType keyType = dictionaryType.getKeyType();
        final MetadataType valueType = dictionaryType.getValueType();
        final Class keyClass = JavaTypeUtils.getType((MetadataType)keyType);
        final Class valueClass = JavaTypeUtils.getType((MetadataType)valueType);
        final String parameterName = paramDsl.getAttributeName();
        String mapElementName = paramDsl.getElementName();
        this.addParameter(this.getChildKey(key), AttributeDefinition.Builder.fromChildMapConfiguration((Class)keyClass, (Class)valueClass).withWrapperIdentifier(mapElementName).withDefaultValue(defaultValue));
        this.addDefinition(this.baseDefinitionBuilder.copy().withIdentifier(mapElementName).withTypeDefinition(TypeDefinition.fromType(mapType)).build());
        Optional mapValueChildDsl = paramDsl.getGeneric(valueType);
        if (!mapValueChildDsl.isPresent()) {
            return;
        }
        final DslElementSyntax valueDsl = (DslElementSyntax)mapValueChildDsl.get();
        valueType.accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                ExtensionDefinitionParser.this.addDefinition(ExtensionDefinitionParser.this.baseDefinitionBuilder.copy().withIdentifier(valueDsl.getElementName()).withTypeDefinition(TypeDefinition.fromMapEntryType((Class)keyClass, (Class)valueClass)).withKeyTypeConverter(value -> ExtensionDefinitionParser.this.resolverOf(parameterName, keyType, value, null, expressionSupport, true, modelProperties, false)).withTypeConverter(value -> ExtensionDefinitionParser.this.resolverOf(parameterName, valueType, value, null, expressionSupport, true, modelProperties, false)).build());
            }

            public void visitObject(ObjectType objectType) {
                this.defaultVisit((MetadataType)objectType);
                if ((valueDsl.supportsTopLevelDeclaration() || valueDsl.supportsChildDeclaration() && !valueDsl.isWrapped()) && !ExtensionDefinitionParser.this.parsingContext.isRegistered(valueDsl.getElementName(), valueDsl.getNamespace())) {
                    try {
                        ExtensionDefinitionParser.this.parsingContext.registerObjectType(valueDsl.getElementName(), valueDsl.getNamespace(), objectType);
                        new ObjectTypeParameterParser(ExtensionDefinitionParser.this.baseDefinitionBuilder.copy(), objectType, ExtensionDefinitionParser.this.getContextClassLoader(), ExtensionDefinitionParser.this.dslResolver, ExtensionDefinitionParser.this.parsingContext, ExtensionDefinitionParser.this.muleContext).parse().forEach(definition -> ExtensionDefinitionParser.this.addDefinition((ComponentBuildingDefinition)definition));
                    }
                    catch (ConfigurationException e) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create parser for map complex type"), (Throwable)e);
                    }
                }
            }

            public void visitArrayType(final ArrayType arrayType) {
                this.defaultVisit((MetadataType)arrayType);
                final Optional valueListGenericDsl = valueDsl.getGeneric(arrayType.getType());
                if (valueDsl.supportsChildDeclaration() && valueListGenericDsl.isPresent()) {
                    arrayType.getType().accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

                        protected void visitBasicType(MetadataType metadataType) {
                            ExtensionDefinitionParser.this.addDefinition(ExtensionDefinitionParser.this.baseDefinitionBuilder.copy().withIdentifier(((DslElementSyntax)valueListGenericDsl.get()).getElementName()).withTypeDefinition(TypeDefinition.fromType((Class)JavaTypeUtils.getType((MetadataType)metadataType))).withTypeConverter(value -> ExtensionDefinitionParser.this.resolverOf(parameterName, metadataType, value, MetadataTypeUtils.getDefaultValue((MetadataType)metadataType), TypeUtils.getExpressionSupport((MetadataType)metadataType), false, modelProperties)).build());
                        }

                        protected void defaultVisit(MetadataType metadataType) {
                            ExtensionDefinitionParser.this.addDefinition(ExtensionDefinitionParser.this.baseDefinitionBuilder.copy().withIdentifier(((DslElementSyntax)valueListGenericDsl.get()).getElementName()).withTypeDefinition(TypeDefinition.fromType(ValueResolver.class)).withObjectFactoryType(TopLevelParameterObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)arrayType.getType()).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)ExtensionDefinitionParser.this.getContextClassLoader()).build()).build());
                        }
                    });
                }
            }
        });
    }

    protected void parseCollectionParameter(ParameterModel parameter, ArrayType arrayType, DslElementSyntax parameterDsl) {
        this.parseCollectionParameter(this.getKey(parameter), parameter.getName(), arrayType, parameter.getDefaultValue(), parameter.getExpressionSupport(), parameter.isRequired(), parameterDsl, parameter.getModelProperties());
    }

    protected void parseCollectionParameter(String key, final String name, ArrayType arrayType, Object defaultValue, ExpressionSupport expressionSupport, boolean required, DslElementSyntax parameterDsl, final Set<ModelProperty> modelProperties) {
        this.parseAttributeParameter(key, name, (MetadataType)arrayType, defaultValue, expressionSupport, required, modelProperties);
        Class collectionType = JavaTypeUtils.getType((MetadataType)arrayType);
        if (Set.class.equals((Object)collectionType)) {
            collectionType = HashSet.class;
        } else if (Collection.class.equals(collectionType) || Iterable.class.equals(collectionType) || collectionType == null) {
            collectionType = List.class;
        }
        String collectionElementName = parameterDsl.getElementName();
        this.addParameter(this.getChildKey(key), AttributeDefinition.Builder.fromChildConfiguration(collectionType).withWrapperIdentifier(collectionElementName));
        this.addDefinition(this.baseDefinitionBuilder.copy().withIdentifier(collectionElementName).withTypeDefinition(TypeDefinition.fromType(collectionType)).build());
        final Optional collectionItemDsl = parameterDsl.getGeneric(arrayType.getType());
        if (parameterDsl.supportsChildDeclaration() && collectionItemDsl.isPresent()) {
            final String itemIdentifier = ((DslElementSyntax)collectionItemDsl.get()).getElementName();
            final String itemNamespace = ((DslElementSyntax)collectionItemDsl.get()).getNamespace();
            arrayType.getType().accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

                private void addBasicTypeDefinition(MetadataType metadataType) {
                    ComponentBuildingDefinition.Builder itemDefinitionBuilder = ExtensionDefinitionParser.this.baseDefinitionBuilder.copy().withIdentifier(itemIdentifier).withNamespace(itemNamespace).withTypeDefinition(TypeDefinition.fromType((Class)JavaTypeUtils.getType((MetadataType)metadataType))).withTypeConverter(value -> ExtensionDefinitionParser.this.resolverOf(name, metadataType, value, MetadataTypeUtils.getDefaultValue((MetadataType)metadataType).orElse(null), TypeUtils.getExpressionSupport((MetadataType)metadataType), false, modelProperties));
                    ExtensionDefinitionParser.this.addDefinition(itemDefinitionBuilder.build());
                }

                protected void visitBasicType(MetadataType metadataType) {
                    this.addBasicTypeDefinition(metadataType);
                }

                public void visitDate(DateType dateType) {
                    this.addBasicTypeDefinition((MetadataType)dateType);
                }

                public void visitDateTime(DateTimeType dateTimeType) {
                    this.addBasicTypeDefinition((MetadataType)dateTimeType);
                }

                public void visitObject(ObjectType objectType) {
                    DslElementSyntax itemDsl = (DslElementSyntax)collectionItemDsl.get();
                    if ((itemDsl.supportsTopLevelDeclaration() || itemDsl.supportsChildDeclaration()) && !ExtensionDefinitionParser.this.parsingContext.isRegistered(itemDsl.getElementName(), itemDsl.getNamespace())) {
                        try {
                            ExtensionDefinitionParser.this.parsingContext.registerObjectType(itemDsl.getElementName(), itemDsl.getNamespace(), objectType);
                            new ObjectTypeParameterParser(ExtensionDefinitionParser.this.baseDefinitionBuilder.copy(), objectType, ExtensionDefinitionParser.this.getContextClassLoader(), ExtensionDefinitionParser.this.dslResolver, ExtensionDefinitionParser.this.parsingContext, ExtensionDefinitionParser.this.muleContext).parse().forEach(definition -> ExtensionDefinitionParser.this.addDefinition((ComponentBuildingDefinition)definition));
                        }
                        catch (ConfigurationException e) {
                            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create parser for collection complex type"), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private ValueResolver<?> resolverOf(String parameterName, MetadataType expectedType, Object value, Object defaultValue, ExpressionSupport expressionSupport, boolean required, Set<ModelProperty> modelProperties) {
        return this.resolverOf(parameterName, expectedType, value, defaultValue, expressionSupport, required, modelProperties, true);
    }

    protected ValueResolver<?> resolverOf(final String parameterName, MetadataType expectedType, final Object value, final Object defaultValue, ExpressionSupport expressionSupport, boolean required, Set<ModelProperty> modelProperties, final boolean acceptsReferences) {
        if (value instanceof ValueResolver) {
            return (ValueResolver)value;
        }
        ExpressionFunctionValueResolver resolver = null;
        if (this.isExpressionFunction(modelProperties) && value != null) {
            resolver = new ExpressionFunctionValueResolver((String)value, expectedType, this.muleContext);
        }
        if (this.isExpressionResolver(modelProperties) && value != null) {
            resolver = new ExpressionBasedParameterResolverValueResolver((String)value, expectedType, this.muleContext);
        }
        final Class expectedClass = JavaTypeUtils.getType((MetadataType)expectedType);
        if (resolver == null && this.isExpression(value, this.parser)) {
            resolver = new TypeSafeExpressionValueResolver((String)value, expectedClass, this.muleContext);
        }
        if (resolver == null && value != null) {
            final ValueHolder resolverValueHolder = new ValueHolder();
            expectedType.accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

                protected void visitBasicType(MetadataType metadataType) {
                    if (ExtensionDefinitionParser.this.conversionService.canConvert(value.getClass(), expectedClass)) {
                        resolverValueHolder.set((Object)new StaticValueResolver(ExtensionDefinitionParser.this.convertSimpleValue(value, expectedClass, parameterName)));
                    } else {
                        this.defaultVisit(metadataType);
                    }
                }

                public void visitDateTime(DateTimeType dateTimeType) {
                    resolverValueHolder.set((Object)ExtensionDefinitionParser.this.parseDate(value, (MetadataType)dateTimeType, defaultValue));
                }

                public void visitDate(DateType dateType) {
                    resolverValueHolder.set((Object)ExtensionDefinitionParser.this.parseDate(value, (MetadataType)dateType, defaultValue));
                }

                public void visitObject(ObjectType objectType) {
                    Optional delegate = ExtensionDefinitionParser.this.locateParsingDelegate(ExtensionDefinitionParser.this.valueResolverParsingDelegates, (MetadataType)objectType);
                    Optional typeDsl = ExtensionDefinitionParser.this.dslResolver.resolve((MetadataType)objectType);
                    Object valueResolver = delegate.isPresent() && typeDsl.isPresent() ? (ValueResolver)((ParsingDelegate)delegate.get()).parse(value.toString(), objectType, (DslElementSyntax)typeDsl.get(), ExtensionDefinitionParser.this.muleContext) : (acceptsReferences ? (ValueResolver)ExtensionDefinitionParser.this.defaultValueResolverParsingDelegate.parse(value.toString(), objectType, null, ExtensionDefinitionParser.this.muleContext) : new StaticValueResolver(value));
                    resolverValueHolder.set(valueResolver);
                }

                protected void defaultVisit(MetadataType metadataType) {
                    ValueResolver delegateResolver = ExtensionDefinitionParser.this.locateParsingDelegate(ExtensionDefinitionParser.this.valueResolverParsingDelegates, metadataType).map(delegate -> (ValueResolver)delegate.parse(value.toString(), metadataType, null, ExtensionDefinitionParser.this.muleContext)).orElseGet(() -> acceptsReferences ? (ValueResolver)ExtensionDefinitionParser.this.defaultValueResolverParsingDelegate.parse(value.toString(), metadataType, null, ExtensionDefinitionParser.this.muleContext) : new StaticValueResolver(value));
                    resolverValueHolder.set((Object)delegateResolver);
                }
            });
            resolver = (ValueResolver)resolverValueHolder.get();
        }
        if (resolver == null) {
            resolver = new StaticValueResolver(defaultValue);
        }
        if (resolver.isDynamic() && expressionSupport == ExpressionSupport.NOT_SUPPORTED) {
            throw new IllegalArgumentException(String.format("An expression value was given for parameter '%s' but it doesn't support expressions", parameterName));
        }
        if (!resolver.isDynamic() && expressionSupport == ExpressionSupport.REQUIRED && required) {
            throw new IllegalArgumentException(String.format("A fixed value was given for parameter '%s' but it only supports expressions", parameterName));
        }
        return resolver;
    }

    protected void parseFromTextExpression(ParameterModel parameter, DslElementSyntax paramDsl, Supplier<TypeConverter> typeConverter) {
        this.parseFromTextExpression(this.getKey(parameter), paramDsl, typeConverter);
    }

    protected void parseFromTextExpression(String key, DslElementSyntax paramDsl, Supplier<TypeConverter> typeConverter) {
        this.addParameter(this.getChildKey(key), AttributeDefinition.Builder.fromChildConfiguration(String.class).withWrapperIdentifier(paramDsl.getElementName()));
        this.addDefinition(this.baseDefinitionBuilder.copy().withIdentifier(paramDsl.getElementName()).withTypeDefinition(TypeDefinition.fromType(String.class)).withTypeConverter(typeConverter.get()).build());
    }

    private boolean isExpression(Object value, TemplateParser parser) {
        return value instanceof String && parser.isContainsTemplate((String)value);
    }

    protected AttributeDefinition.Builder parseAttributeParameter(ParameterModel parameterModel) {
        return this.parseAttributeParameter(this.getKey(parameterModel), parameterModel.getName(), parameterModel.getType(), parameterModel.getDefaultValue(), parameterModel.getExpressionSupport(), parameterModel.isRequired(), parameterModel.getModelProperties());
    }

    protected AttributeDefinition.Builder parseAttributeParameter(String key, String name, MetadataType type, Object defaultValue, ExpressionSupport expressionSupport, boolean required, Set<ModelProperty> modelProperties) {
        return this.parseAttributeParameter(key, name, type, defaultValue, expressionSupport, required, true, modelProperties);
    }

    private AttributeDefinition.Builder parseAttributeParameter(String key, String name, MetadataType type, Object defaultValue, ExpressionSupport expressionSupport, boolean required, boolean acceptsReferences, Set<ModelProperty> modelProperties) {
        AttributeDefinition.Builder definitionBuilder = AttributeDefinition.Builder.fromSimpleParameter((String)name, value -> this.resolverOf(name, type, value, defaultValue, expressionSupport, required, modelProperties, acceptsReferences)).withDefaultValue(defaultValue);
        this.addParameter(key, definitionBuilder);
        return definitionBuilder;
    }

    protected void parseObjectParameter(ParameterModel parameterModel, DslElementSyntax paramDsl) {
        if (ExtensionModelUtils.isContent((ParameterModel)parameterModel)) {
            this.parseFromTextExpression(parameterModel, paramDsl, () -> value -> this.resolverOf(parameterModel.getName(), parameterModel.getType(), value, parameterModel.getDefaultValue(), parameterModel.getExpressionSupport(), parameterModel.isRequired(), parameterModel.getModelProperties(), this.acceptsReferences(parameterModel)));
        } else {
            this.parseObjectParameter(this.getKey(parameterModel), parameterModel.getName(), (ObjectType)parameterModel.getType(), parameterModel.getDefaultValue(), parameterModel.getExpressionSupport(), parameterModel.isRequired(), this.acceptsReferences(parameterModel), paramDsl, parameterModel.getModelProperties());
        }
    }

    protected void parseObjectParameter(String key, String name, ObjectType type, Object defaultValue, ExpressionSupport expressionSupport, boolean required, boolean acceptsReferences, DslElementSyntax elementDsl, Set<ModelProperty> modelProperties) {
        this.parseObject(key, name, type, defaultValue, expressionSupport, required, acceptsReferences, elementDsl, modelProperties);
        String elementNamespace = elementDsl.getNamespace();
        String elementName = elementDsl.getElementName();
        if (elementDsl.supportsChildDeclaration() && !elementDsl.isWrapped()) {
            try {
                new ObjectTypeParameterParser(this.baseDefinitionBuilder.copy(), elementName, elementNamespace, type, this.getContextClassLoader(), this.dslResolver, this.parsingContext, this.muleContext).parse().forEach(this::addDefinition);
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)new ConfigurationException((Throwable)e));
            }
        }
    }

    protected void parseObject(String key, String name, ObjectType type, Object defaultValue, ExpressionSupport expressionSupport, boolean required, boolean acceptsReferences, DslElementSyntax elementDsl, Set<ModelProperty> modelProperties) {
        this.parseAttributeParameter(key, name, (MetadataType)type, defaultValue, expressionSupport, required, acceptsReferences, modelProperties);
        ObjectParsingDelegate delegate = (ObjectParsingDelegate)this.locateParsingDelegate(this.objectParsingDelegates, type).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not find a parsing delegate for type " + JavaTypeUtils.getType((MetadataType)type).getName()))));
        this.addParameter(this.getChildKey(key), (AttributeDefinition.Builder)delegate.parse(name, type, elementDsl, this.muleContext));
    }

    private <M extends MetadataType, T> Optional<ParsingDelegate<M, T>> locateParsingDelegate(List<? extends ParsingDelegate<M, T>> delegatesList, M metadataType) {
        return delegatesList.stream().filter(candidate -> candidate.accepts(metadataType)).findFirst();
    }

    protected void addDefinition(ComponentBuildingDefinition definition) {
        this.parsedDefinitions.add(definition);
    }

    protected void addParameter(String key, AttributeDefinition.Builder definitionBuilder) {
        if (this.parameters.put(key, definitionBuilder) != null) {
            throw new IllegalArgumentException("An AttributeDefinition builder was already defined for parameter " + key);
        }
    }

    private void parseNestedProcessor(ParameterModel parameterModel) {
        String processorElementName = NameUtils.hyphenize((String)parameterModel.getName());
        this.addParameter(this.getChildKey(parameterModel.getName()), AttributeDefinition.Builder.fromChildConfiguration(NestedProcessorValueResolver.class).withWrapperIdentifier(processorElementName));
        this.addDefinition(this.baseDefinitionBuilder.copy().withIdentifier(processorElementName).withTypeDefinition(TypeDefinition.fromType(NestedProcessorValueResolver.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildConfiguration(Processor.class).build()).build());
    }

    private void parseNestedProcessorList(ParameterModel parameterModel) {
        String processorElementName = NameUtils.hyphenize((String)parameterModel.getName());
        this.addParameter(this.getChildKey(parameterModel.getName()), AttributeDefinition.Builder.fromChildCollectionConfiguration(NestedProcessorListValueResolver.class).withWrapperIdentifier(processorElementName));
        this.addDefinition(this.baseDefinitionBuilder.copy().withIdentifier(processorElementName).withTypeDefinition(TypeDefinition.fromType(NestedProcessorListValueResolver.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
    }

    private boolean isExpressionFunction(Set<ModelProperty> modelProperties) {
        return modelProperties.stream().anyMatch(property -> property instanceof FunctionParameterTypeModelProperty);
    }

    private boolean isExpressionResolver(Set<ModelProperty> modelProperties) {
        return modelProperties.stream().anyMatch(property -> property instanceof ParameterResolverTypeModelProperty);
    }

    private ValueResolver doParseDate(Object value, Class<?> type) {
        if (value instanceof String) {
            Comparable<Date> constructedValue = null;
            DateTime dateTime = this.getParsedDateTime((String)value);
            if (type.equals(LocalDate.class)) {
                constructedValue = LocalDate.of(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth());
            } else if (type.equals(Date.class)) {
                constructedValue = dateTime.toDate();
            } else if (type.equals(LocalDateTime.class)) {
                Instant instant = Instant.ofEpochMilli(dateTime.getMillis());
                constructedValue = LocalDateTime.ofInstant(instant, ZoneId.of(dateTime.getZone().getID()));
            } else if (type.equals(Calendar.class)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dateTime.toDate());
                constructedValue = calendar;
            }
            if (constructedValue == null) {
                throw new IllegalArgumentException(String.format("Could not construct value of type '%s' from String '%s'", type.getName(), value));
            }
            value = constructedValue;
        }
        if (value instanceof Date || value instanceof LocalDate || value instanceof LocalDateTime || value instanceof Calendar) {
            return new StaticValueResolver(value);
        }
        throw new IllegalArgumentException(String.format("Could not transform value of type '%s' to a valid date type", value != null ? value.getClass().getName() : "null"));
    }

    private DateTime getParsedDateTime(String value) {
        try {
            return ISODateTimeFormat.dateTimeParser().withOffsetParsed().parseDateTime(value);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(String.format("Could not parse value '%s' according to ISO 8601", value));
        }
    }

    private ValueResolver parseDate(Object value, MetadataType dateType, Object defaultValue) {
        Class type = JavaTypeUtils.getType((MetadataType)dateType);
        if (this.isExpression(value, this.parser)) {
            return new TypeSafeExpressionValueResolver((String)value, type, this.muleContext);
        }
        if (value == null) {
            if (defaultValue == null) {
                return new StaticValueResolver(null);
            }
            value = defaultValue;
        }
        return this.doParseDate(value, type);
    }

    private String getKey(ParameterModel parameterModel) {
        return IntrospectionUtils.getMemberName((EnrichableModel)parameterModel, (String)parameterModel.getName());
    }

    private String getChildKey(String key) {
        return String.format("%s%s%s", CHILD_ELEMENT_KEY_PREFIX, key, CHILD_ELEMENT_KEY_SUFFIX);
    }

    private Object convertSimpleValue(Object value, Class<Object> expectedClass, String parameterName) {
        try {
            return this.conversionService.convert(value, expectedClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not transform simple value '%s' to type '%s' in parameter '%s'", value, expectedClass.getSimpleName(), parameterName));
        }
    }

    private boolean acceptsReferences(ParameterModel parameterModel) {
        return parameterModel.getDslModel().allowsReferences();
    }
}

