/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.util.collection.ImmutableListCollector;
import org.mule.runtime.core.util.func.CompositePredicate;
import org.mule.runtime.dsl.api.component.AbstractAnnotatedObjectFactory;
import org.mule.runtime.module.extension.internal.model.property.NullSafeModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.NullSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public abstract class AbstractExtensionObjectFactory<T>
extends AbstractAnnotatedObjectFactory<T> {
    protected final MuleContext muleContext;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public AbstractExtensionObjectFactory(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = this.normalize(parameters);
    }

    protected ResolverSet getParametersAsResolverSet(ParameterizedModel model, Predicate<ParameterModel> ... predicates) throws ConfigurationException {
        ResolverSet resolverSet = new ResolverSet();
        Map<String, Object> parameters = this.getParameters();
        model.getAllParameterModels().stream().filter(CompositePredicate.of((Predicate[])predicates)).forEach(p -> {
            String parameterName = IntrospectionUtils.getMemberName((EnrichableModel)p, (String)p.getName());
            StaticValueResolver resolver = null;
            if (parameters.containsKey(parameterName)) {
                resolver = this.toValueResolver(parameters.get(parameterName));
            } else {
                Object defaultValue = p.getDefaultValue();
                if (defaultValue instanceof String) {
                    resolver = new TypeSafeExpressionValueResolver((String)defaultValue, JavaTypeUtils.getType((MetadataType)p.getType()), this.muleContext);
                } else if (defaultValue != null) {
                    resolver = new StaticValueResolver(defaultValue);
                }
            }
            if (MuleExtensionUtils.isNullSafe((ParameterModel)p)) {
                MetadataType type = ((NullSafeModelProperty)p.getModelProperty(NullSafeModelProperty.class).get()).defaultType();
                StaticValueResolver delegate = resolver != null ? resolver : new StaticValueResolver(null);
                resolver = NullSafeValueResolverWrapper.of((ValueResolver)delegate, (MetadataType)type, (MuleContext)this.muleContext);
            }
            if (resolver != null) {
                resolverSet.add(parameterName, (ValueResolver)resolver);
            }
        });
        this.checkParameterGroupExclusiveness(model, this.getParameters().keySet());
        return resolverSet;
    }

    protected ValueResolver<?> toValueResolver(Object value) {
        ValueResolver resolver;
        if (value instanceof ValueResolver) {
            resolver = (ValueResolver)value;
        } else if (value instanceof Collection) {
            resolver = CollectionValueResolver.of(value.getClass(), (List)((List)((Collection)value).stream().map(this::toValueResolver).collect(new ImmutableListCollector())));
        } else if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap normalizedMap = new LinkedHashMap(map.size());
            map.forEach((key, entryValue) -> normalizedMap.put(this.toValueResolver(key), this.toValueResolver(entryValue)));
            resolver = MapValueResolver.of(map.getClass(), (List)ImmutableList.copyOf(normalizedMap.keySet()), (List)ImmutableList.copyOf(normalizedMap.values()));
        } else {
            resolver = new StaticValueResolver(value);
        }
        return resolver;
    }

    private Map<String, Object> normalize(Map<String, Object> parameters) {
        HashMap<String, Object> normalized = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            String normalizedKey = key;
            if (this.isChildKey((String)key)) {
                normalizedKey = this.unwrapChildKey((String)key);
                normalized.put(normalizedKey, value);
            } else if (!normalized.containsKey(normalizedKey)) {
                normalized.put(normalizedKey, value);
            }
        });
        return normalized;
    }

    private boolean isChildKey(String key) {
        return key.startsWith("<<") && key.endsWith(">>");
    }

    private String unwrapChildKey(String key) {
        return key.replaceAll("<<", "").replaceAll(">>", "");
    }

    protected void checkParameterGroupExclusiveness(ParameterizedModel model, Set<String> resolverKeys) throws ConfigurationException {
        for (ParameterGroupModel group : model.getParameterGroupModels()) {
            for (ExclusiveParametersModel exclusiveModel : group.getExclusiveParametersModels()) {
                Collection definedExclusiveParameters = CollectionUtils.intersection((Collection)exclusiveModel.getExclusiveParameterNames(), resolverKeys);
                if (definedExclusiveParameters.isEmpty() && exclusiveModel.isOneRequired()) {
                    throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Parameter group '%s' requires that one of its optional parameters should be set but all of them are missing. One of the following should be set: [%s]", group.getName(), Joiner.on((String)", ").join((Iterable)exclusiveModel.getExclusiveParameterNames()))));
                }
                if (definedExclusiveParameters.size() <= 1) continue;
                throw this.buildExclusiveParametersException(model, definedExclusiveParameters);
            }
        }
    }

    private ConfigurationException buildExclusiveParametersException(ParameterizedModel model, Collection<String> definedExclusiveParameters) {
        return new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("In %s '%s', the following parameters cannot be set at the same time: [%s]", IntrospectionUtils.getComponentModelTypeName((Object)model), IntrospectionUtils.getModelName((Object)model), Joiner.on((String)", ").join(definedExclusiveParameters))));
    }
}

