/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.util.ValueHolder;
import org.mule.runtime.extension.xml.dsl.api.DslElementSyntax;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.ExecutableTypeSchemaDelegate;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.Attribute;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;
import org.mule.runtime.module.extension.internal.model.property.ExtendingOperationModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.xml.SchemaConstants;

class OperationSchemaDelegate
extends ExecutableTypeSchemaDelegate {
    public OperationSchemaDelegate(SchemaBuilder builder) {
        super(builder);
    }

    public void registerOperation(OperationModel operationModel, DslElementSyntax dslSyntax) {
        String typeName = StringUtils.capitalize((String)operationModel.getName()) + "Type";
        this.registerProcessorElement(operationModel, typeName, dslSyntax);
        this.registerOperationType(typeName, operationModel, dslSyntax);
    }

    private void registerProcessorElement(OperationModel operationModel, String typeName, DslElementSyntax dslSyntax) {
        TopLevelElement element = new TopLevelElement();
        element.setName(dslSyntax.getElementName());
        element.setType(new QName(this.builder.getSchema().getTargetNamespace(), typeName));
        element.setAnnotation(this.builder.createDocAnnotation(operationModel.getDescription()));
        element.setSubstitutionGroup(this.getOperationSubstitutionGroup(operationModel));
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(element);
    }

    private void registerOperationType(String name, OperationModel operationModel, DslElementSyntax dslSyntax) {
        ExtensionType operationType = this.registerExecutableType(name, (ParameterizedModel)operationModel, SchemaConstants.MULE_ABSTRACT_OPERATOR_TYPE, dslSyntax);
        this.addTargetParameter(operationType, operationModel);
    }

    private QName getOperationSubstitutionGroup(OperationModel operationModel) {
        ValueHolder substitutionGroup = new ValueHolder((Object)SchemaConstants.MULE_ABSTRACT_OPERATOR);
        operationModel.getModelProperty(ExtendingOperationModelProperty.class).ifPresent(property -> {
            QName cfr_ignored_0 = (QName)substitutionGroup.set((Object)this.getSubstitutionGroup(property.getType()));
        });
        return (QName)substitutionGroup.get();
    }

    private void addTargetParameter(ExtensionType operationType, OperationModel operationModel) {
        if (!IntrospectionUtils.isVoid((ComponentModel)operationModel)) {
            Attribute attribute = this.builder.createAttribute("target", this.builder.load(String.class), false, ExpressionSupport.NOT_SUPPORTED);
            attribute.setAnnotation(this.builder.createDocAnnotation("The name of a variable on which the operation's output will be placed"));
            operationType.getAttributeOrAttributeGroup().add(attribute);
        }
    }
}

