/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import java.math.BigInteger;
import java.util.List;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.xml.dsl.api.DslElementSyntax;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.Attribute;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.LocalComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ObjectFactory;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;
import org.mule.runtime.module.extension.internal.util.ExtensionMetadataTypeUtils;

final class MapSchemaDelegate {
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final SchemaBuilder builder;

    MapSchemaDelegate(SchemaBuilder builder) {
        this.builder = builder;
    }

    void generateMapElement(DictionaryType metadataType, DslElementSyntax paramDsl, String description, boolean required, List<TopLevelElement> all) {
        BigInteger minOccurs = required ? BigInteger.ONE : BigInteger.ZERO;
        LocalComplexType mapComplexType = this.generateMapComplexType(paramDsl, metadataType);
        TopLevelElement mapElement = this.builder.createTopLevelElement(paramDsl.getElementName(), minOccurs, "1");
        mapElement.setAnnotation(this.builder.createDocAnnotation(description));
        mapElement.setComplexType(mapComplexType);
        all.add(mapElement);
    }

    private LocalComplexType generateMapComplexType(DslElementSyntax mapDsl, DictionaryType metadataType) {
        MetadataType keyType = metadataType.getKeyType();
        final MetadataType valueType = metadataType.getValueType();
        final LocalComplexType entryComplexType = new LocalComplexType();
        Attribute keyAttribute = this.builder.createAttribute("key", keyType, true, ExpressionSupport.REQUIRED);
        entryComplexType.getAttributeOrAttributeGroup().add(keyAttribute);
        LocalComplexType mapComplexType = new LocalComplexType();
        ExplicitGroup mapEntrySequence = new ExplicitGroup();
        mapComplexType.setSequence(mapEntrySequence);
        final DslElementSyntax entryValueDsl = (DslElementSyntax)mapDsl.getGeneric(valueType).orElseThrow(() -> new IllegalArgumentException("Illegal DslSyntax definition of the given DictionaryType. The DslElementSyntax for the entry is required"));
        TopLevelElement mapEntryElement = new TopLevelElement();
        mapEntryElement.setName(entryValueDsl.getElementName());
        mapEntryElement.setMinOccurs(BigInteger.ZERO);
        mapEntryElement.setMaxOccurs("unbounded");
        valueType.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                boolean shouldGenerateChildElement = entryValueDsl.supportsChildDeclaration();
                entryComplexType.getAttributeOrAttributeGroup().add(MapSchemaDelegate.this.builder.createAttribute("value", valueType, !shouldGenerateChildElement, ExpressionSupport.SUPPORTED));
                if (shouldGenerateChildElement) {
                    DslElementSyntax typeDsl = (DslElementSyntax)MapSchemaDelegate.this.builder.getDslResolver().resolve((MetadataType)objectType).orElseThrow(() -> new IllegalArgumentException(String.format("The given type [%s] cannot be represented as a child element in Map entries", ExtensionMetadataTypeUtils.getId((MetadataType)objectType))));
                    if (typeDsl.isWrapped()) {
                        ExplicitGroup choice = MapSchemaDelegate.this.builder.createTypeRefChoiceLocalOrGlobal(typeDsl, (MetadataType)objectType, BigInteger.ZERO, "unbounded");
                        entryComplexType.setChoice(choice);
                    } else {
                        ExplicitGroup singleItemSequence = new ExplicitGroup();
                        singleItemSequence.setMaxOccurs("1");
                        TopLevelElement mapItemElement = MapSchemaDelegate.this.builder.createTypeRef(typeDsl, objectType, false);
                        singleItemSequence.getParticle().add(MapSchemaDelegate.this.objectFactory.createElement(mapItemElement));
                        entryComplexType.setSequence(singleItemSequence);
                    }
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                entryComplexType.getAttributeOrAttributeGroup().add(MapSchemaDelegate.this.builder.createAttribute("value", valueType, false, ExpressionSupport.SUPPORTED));
                entryComplexType.setSequence(new ExplicitGroup());
                LocalComplexType itemComplexType = new LocalComplexType();
                MetadataType itemType = arrayType.getType();
                itemComplexType.getAttributeOrAttributeGroup().add(MapSchemaDelegate.this.builder.createAttribute("value", itemType, true, ExpressionSupport.REQUIRED));
                DslElementSyntax itemDsl = (DslElementSyntax)entryValueDsl.getGeneric(itemType).orElseThrow(() -> new IllegalArgumentException("Illegal DslSyntax definition of the given ArrayType. The DslElementSyntax for the item is required"));
                TopLevelElement itemElement = MapSchemaDelegate.this.builder.createTopLevelElement(itemDsl.getElementName(), BigInteger.ZERO, "unbounded", itemComplexType);
                entryComplexType.getSequence().getParticle().add(MapSchemaDelegate.this.objectFactory.createElement(itemElement));
            }

            protected void defaultVisit(MetadataType metadataType) {
                entryComplexType.getAttributeOrAttributeGroup().add(MapSchemaDelegate.this.builder.createValueAttribute(valueType));
            }
        });
        mapEntryElement.setComplexType(entryComplexType);
        mapEntrySequence.getParticle().add(this.objectFactory.createElement(mapEntryElement));
        return mapComplexType;
    }
}

