/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import java.math.BigInteger;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.xml.dsl.api.DslElementSyntax;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ComplexContent;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.LocalComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ObjectFactory;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;
import org.mule.runtime.module.extension.internal.xml.SchemaConstants;

final class ConnectionProviderSchemaDelegate {
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final SchemaBuilder builder;
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    ConnectionProviderSchemaDelegate(SchemaBuilder builder) {
        this.builder = builder;
    }

    void registerConnectionProviderElement(ConnectionProviderModel providerModel, DslElementSyntax elementSyntax) {
        TopLevelElement providerElement = new TopLevelElement();
        providerElement.setName(elementSyntax.getElementName());
        providerElement.setSubstitutionGroup(SchemaConstants.MULE_EXTENSION_CONNECTION_PROVIDER_ELEMENT);
        LocalComplexType complexType = new LocalComplexType();
        providerElement.setComplexType(complexType);
        ExtensionType providerType = new ExtensionType();
        providerType.setBase(SchemaConstants.MULE_EXTENSION_CONNECTION_PROVIDER_TYPE);
        ComplexContent complexContent = new ComplexContent();
        complexContent.setExtension(providerType);
        complexType.setComplexContent(complexContent);
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(providerElement);
        ExplicitGroup sequence = new ExplicitGroup();
        sequence.setMinOccurs(BigInteger.ZERO);
        sequence.setMaxOccurs("1");
        this.builder.addRetryPolicy(sequence);
        ConnectionManagementType managementType = providerModel.getConnectionManagementType();
        if (managementType == ConnectionManagementType.POOLING || managementType == ConnectionManagementType.CACHED) {
            this.addValidationFlag(providerType);
        }
        if (managementType == ConnectionManagementType.POOLING) {
            this.addConnectionProviderPoolingProfile(sequence);
        }
        providerModel.getParameterGroupModels().forEach(g -> this.builder.addParameterGroupsToSequence(this.builder.registerParameters(providerType, g.getParameterModels()), sequence));
        providerType.setSequence(sequence);
    }

    private void addConnectionProviderPoolingProfile(ExplicitGroup sequence) {
        TopLevelElement objectElement = this.builder.createRefElement(SchemaConstants.MULE_POOLING_PROFILE_TYPE, false);
        sequence.getParticle().add(this.objectFactory.createElement(objectElement));
    }

    private void addValidationFlag(ExtensionType providerType) {
        providerType.getAttributeOrAttributeGroup().add(this.builder.createAttribute("disableValidation", this.typeLoader.load(Boolean.TYPE), false, ExpressionSupport.NOT_SUPPORTED));
    }
}

