/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.registry.SpiServiceRegistry;
import org.mule.runtime.core.util.annotation.AnnotationUtils;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.runtime.ExtensionFactory;
import org.mule.runtime.extension.xml.dsl.api.resolver.DslResolvingContext;
import org.mule.runtime.module.extension.internal.DefaultDescribingContext;
import org.mule.runtime.module.extension.internal.introspection.DefaultExtensionFactory;
import org.mule.runtime.module.extension.internal.introspection.describer.AnnotationsBasedDescriber;
import org.mule.runtime.module.extension.internal.introspection.version.StaticVersionResolver;
import org.mule.runtime.module.extension.internal.introspection.version.VersionResolver;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

class ClasspathBasedDslContext
implements DslResolvingContext {
    private final ClassLoader classLoader;
    private final Map<String, Class<?>> extensionsByName = new HashMap();
    private final Map<String, ExtensionModel> resolvedModels = new HashMap<String, ExtensionModel>();
    private final ExtensionFactory extensionFactory = new DefaultExtensionFactory((ServiceRegistry)new SpiServiceRegistry(), this.getClass().getClassLoader());

    ClasspathBasedDslContext(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.findExtensionsInClasspath();
    }

    public Optional<ExtensionModel> getExtension(String name) {
        if (!this.resolvedModels.containsKey(name) && this.extensionsByName.containsKey(name)) {
            AnnotationsBasedDescriber describer = new AnnotationsBasedDescriber(this.extensionsByName.get(name), (VersionResolver)new StaticVersionResolver("4.0"));
            DefaultDescribingContext context = new DefaultDescribingContext(this.getClass().getClassLoader());
            this.resolvedModels.put(name, this.extensionFactory.createFrom(describer.describe((DescribingContext)context), (DescribingContext)context));
        }
        return Optional.ofNullable(this.resolvedModels.get(name));
    }

    private void findExtensionsInClasspath() {
        Set<Class<?>> annotated = this.getExtensionTypes(ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{this.classLoader}));
        annotated.forEach(type -> AnnotationUtils.getAnnotation((Class)type, Extension.class).ifPresent(extension -> this.extensionsByName.put(extension.name(), (Class<?>)type)));
    }

    private Set<Class<?>> getExtensionTypes(Collection<URL> urls) {
        try {
            return new Reflections((Configuration)new ConfigurationBuilder().setUrls(urls).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()})).getTypesAnnotatedWith(Extension.class);
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }
}

