/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.config;

import java.util.List;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Operation;
import org.mule.module.extension.internal.config.ElementDescriptor;
import org.mule.module.extension.internal.config.XmlExtensionParserUtils;
import org.mule.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.module.extension.internal.runtime.processor.OperationMessageProcessor;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.util.ObjectNameHelper;
import org.springframework.beans.factory.FactoryBean;

public class OperationMessageProcessorFactoryBean
implements FactoryBean<OperationMessageProcessor> {
    private final String configurationInstanceProviderName;
    private final Extension extension;
    private final Operation operation;
    private final ElementDescriptor element;
    private final ExtensionManagerAdapter extensionManager;
    private final Map<String, List<MessageProcessor>> nestedOperations;

    public OperationMessageProcessorFactoryBean(String configurationInstanceProviderName, Extension extension, Operation operation, ElementDescriptor element, Map<String, List<MessageProcessor>> nestedOperations, MuleContext muleContext) {
        this.configurationInstanceProviderName = configurationInstanceProviderName;
        this.extension = extension;
        this.operation = operation;
        this.element = element;
        this.extensionManager = (ExtensionManagerAdapter)muleContext.getExtensionManager();
        this.nestedOperations = nestedOperations;
        this.registerNestedProcessors(nestedOperations, muleContext);
    }

    public OperationMessageProcessor getObject() throws Exception {
        ResolverSet resolverSet = XmlExtensionParserUtils.getResolverSet(this.element, this.operation.getParameters(), this.nestedOperations);
        return new OperationMessageProcessor(this.extension, this.operation, this.configurationInstanceProviderName, resolverSet, this.extensionManager);
    }

    public Class<?> getObjectType() {
        return OperationMessageProcessor.class;
    }

    public boolean isSingleton() {
        return false;
    }

    private void registerNestedProcessors(Map<String, List<MessageProcessor>> nestedOperations, MuleContext muleContext) {
        if (!nestedOperations.isEmpty()) {
            ObjectNameHelper objectNameHelper = new ObjectNameHelper(muleContext);
            for (List<MessageProcessor> messageProcessors : nestedOperations.values()) {
                try {
                    for (MessageProcessor messageProcessor : messageProcessors) {
                        muleContext.getRegistry().registerObject(objectNameHelper.getUniqueName(""), (Object)messageProcessor);
                    }
                }
                catch (RegistrationException e) {
                    throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Could not register nested processor"), (Throwable)e);
                }
            }
        }
    }
}

